/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.enumerator;

import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.query.enumerator.DictionaryEnumerator;
import org.apache.kylin.query.enumerator.HiveEnumerator;
import org.apache.kylin.query.enumerator.LookupTableEnumerator;
import org.apache.kylin.query.enumerator.OLAPEnumerator;
import org.apache.kylin.query.relnode.OLAPContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OLAPQuery
extends AbstractEnumerable<Object[]>
implements Enumerable<Object[]> {
    private static final Logger logger = LoggerFactory.getLogger(OLAPQuery.class);
    private final DataContext optiqContext;
    private final EnumeratorTypeEnum type;
    private final int contextId;

    public OLAPQuery(DataContext optiqContext, EnumeratorTypeEnum type, int ctxId) {
        this.optiqContext = optiqContext;
        this.type = type;
        this.contextId = ctxId;
        QueryContextFacade.current().addContext(ctxId, type.toString(), type == EnumeratorTypeEnum.OLAP);
    }

    public OLAPQuery(EnumeratorTypeEnum type, int ctxSeq) {
        this(null, type, ctxSeq);
    }

    public Enumerator<Object[]> enumerator() {
        OLAPContext olapContext = OLAPContext.getThreadLocalContextById(this.contextId);
        switch (this.type) {
            case OLAP: {
                return BackdoorToggles.getPrepareOnly() ? new EmptyEnumerator() : new OLAPEnumerator(olapContext, this.optiqContext);
            }
            case LOOKUP_TABLE: {
                return BackdoorToggles.getPrepareOnly() ? new EmptyEnumerator() : new LookupTableEnumerator(olapContext);
            }
            case COL_DICT: {
                return BackdoorToggles.getPrepareOnly() ? new EmptyEnumerator() : new DictionaryEnumerator(olapContext);
            }
            case HIVE: {
                return BackdoorToggles.getPrepareOnly() ? new EmptyEnumerator() : new HiveEnumerator(olapContext);
            }
        }
        throw new IllegalArgumentException("Wrong type " + (Object)((Object)this.type) + "!");
    }

    public static class EmptyEnumerator
    implements Enumerator<Object[]> {
        public EmptyEnumerator() {
            logger.debug("Using empty enumerator");
        }

        public void close() {
        }

        public Object[] current() {
            return null;
        }

        public boolean moveNext() {
            return false;
        }

        public void reset() {
        }
    }

    public static enum EnumeratorTypeEnum {
        OLAP,
        LOOKUP_TABLE,
        HIVE,
        COL_DICT;

    }
}

