/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.service.MetricsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/jmetrics"})
public class MetricsController
extends BasicController {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsController.class);
    @Autowired
    private MetricsService metricsService;

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity getAllMetrics() {
        return this.getMetrics(null);
    }

    @RequestMapping(value={"/{type}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity getMetrics(@PathVariable String type) {
        String metrics = null;
        try {
            metrics = this.metricsService.getMetrics(type);
        }
        catch (IllegalStateException e) {
            LOG.error("get metrics error, type:{}", (Object)type, (Object)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOG.error("get metrics error, type:{}", (Object)type, (Object)e);
            return new ResponseEntity((Object)"Internal error", HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)metrics, HttpStatus.OK);
    }
}

