/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.metrics;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;

@Metrics(name="Query", about="Query metrics", context="Kylin")
@ThreadSafe
public class QueryMetrics {
    final MetricsRegistry registry = new MetricsRegistry("Query");
    @Metric
    MutableCounterLong querySuccessCount;
    @Metric
    MutableCounterLong queryFailCount;
    @Metric
    MutableCounterLong queryCount;
    @Metric
    MutableCounterLong cacheHitCount;
    MutableQuantiles[] cacheHitCountQuantiles;
    @Metric
    MutableRate queryLatency;
    MutableQuantiles[] queryLatencyTimeMillisQuantiles;
    @Metric
    MutableRate scanRowCount;
    MutableQuantiles[] scanRowCountQuantiles;
    @Metric
    MutableRate resultRowCount;
    MutableQuantiles[] resultRowCountQuantiles;

    public QueryMetrics(int[] intervals) {
        this.queryLatencyTimeMillisQuantiles = new MutableQuantiles[intervals.length];
        this.scanRowCountQuantiles = new MutableQuantiles[intervals.length];
        this.resultRowCountQuantiles = new MutableQuantiles[intervals.length];
        this.cacheHitCountQuantiles = new MutableQuantiles[intervals.length];
        for (int i = 0; i < intervals.length; ++i) {
            int interval = intervals[i];
            this.queryLatencyTimeMillisQuantiles[i] = this.registry.newQuantiles("QueryLatency" + interval + "s", "Query queue time in milli second", "ops", "", interval);
            this.scanRowCountQuantiles[i] = this.registry.newQuantiles("ScanRowCount" + interval + "s", "Scan row count in milli second", "ops", "", interval);
            this.resultRowCountQuantiles[i] = this.registry.newQuantiles("ResultRowCount" + interval + "s", "Result row count in milli second", "ops", "", interval);
            this.cacheHitCountQuantiles[i] = this.registry.newQuantiles("CacheHitCount" + interval + "s", "Cache Hit Count in milli second", "ops", "", interval);
        }
        this.queryLatency = this.registry.newRate("QueryLatency", "", true);
        this.scanRowCount = this.registry.newRate("ScanRowCount", "", true);
        this.resultRowCount = this.registry.newRate("ResultRowCount", "", true);
    }

    public void shutdown() {
        DefaultMetricsSystem.shutdown();
    }

    public void incrQuerySuccessCount() {
        this.querySuccessCount.incr();
    }

    public void incrQueryFailCount() {
        this.queryFailCount.incr();
    }

    public void incrQueryCount() {
        this.queryCount.incr();
    }

    public void addQueryLatency(long latency) {
        this.queryLatency.add(latency);
        for (MutableQuantiles m : this.queryLatencyTimeMillisQuantiles) {
            m.add(latency);
        }
    }

    public void addScanRowCount(long count) {
        this.scanRowCount.add(count);
        for (MutableQuantiles m : this.scanRowCountQuantiles) {
            m.add(count);
        }
    }

    public void addResultRowCount(long count) {
        this.resultRowCount.add(count);
        for (MutableQuantiles m : this.resultRowCountQuantiles) {
            m.add(count);
        }
    }

    public void addCacheHitCount(long count) {
        this.cacheHitCount.incr(count);
        for (MutableQuantiles m : this.cacheHitCountQuantiles) {
            m.add(count);
        }
    }

    public QueryMetrics registerWith(String name) {
        return (QueryMetrics)DefaultMetricsSystem.instance().register(name, "Query", (Object)this);
    }
}

