/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.CheckpointExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.rest.util.AclUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;

@Component(value="aclEvaluate")
public class AclEvaluate {
    @Autowired
    private AclUtil aclUtil;

    private ProjectInstance getProjectInstance(String projectName) {
        return ProjectManager.getInstance(KylinConfig.getInstanceFromEnv()).getProject(projectName);
    }

    private ProjectInstance getProjectInstanceByCubeName(String cube) {
        CubeInstance cubeInstance = CubeManager.getInstance(KylinConfig.getInstanceFromEnv()).getCube(cube);
        return cubeInstance.getProjectInstance();
    }

    private ProjectInstance getProjectByJob(JobInstance job) {
        AbstractExecutable executable = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv()).getJob(job.getUuid());
        String projectName = null;
        if (executable instanceof CubingJob) {
            projectName = ((CubingJob)executable).getProjectName();
        } else if (executable instanceof CheckpointExecutable) {
            projectName = ((CheckpointExecutable)executable).getProjectName();
        } else {
            return null;
        }
        return this.getProjectInstance(projectName);
    }

    public void checkProjectAdminPermission(ProjectInstance projectInstance) {
        this.aclUtil.hasProjectAdminPermission(projectInstance);
    }

    public void checkProjectReadPermission(ProjectInstance projectInstance) {
        this.aclUtil.hasProjectReadPermission(projectInstance);
    }

    public void checkProjectWritePermission(ProjectInstance projectInstance) {
        this.aclUtil.hasProjectWritePermission(projectInstance);
    }

    public void checkProjectOperationPermission(ProjectInstance projectInstance) {
        this.aclUtil.hasProjectOperationPermission(projectInstance);
    }

    public void checkProjectAdminPermission(String projectName) {
        ProjectInstance projectInstance = this.getProjectInstance(projectName);
        this.checkProjectAdminPermission(projectInstance);
    }

    public void checkProjectReadPermission(String projectName) {
        ProjectInstance projectInstance = this.getProjectInstance(projectName);
        this.checkProjectReadPermission(projectInstance);
    }

    public void checkProjectWritePermission(String projectName) {
        ProjectInstance projectInstance = this.getProjectInstance(projectName);
        this.checkProjectWritePermission(projectInstance);
    }

    public void checkProjectOperationPermission(String projectName) {
        ProjectInstance projectInstance = this.getProjectInstance(projectName);
        this.checkProjectOperationPermission(projectInstance);
    }

    public void checkProjectReadPermission(CubeInstance cube) {
        this.aclUtil.hasProjectReadPermission(cube.getProjectInstance());
    }

    public void checkProjectWritePermission(CubeInstance cube) {
        this.aclUtil.hasProjectWritePermission(cube.getProjectInstance());
    }

    public void checkProjectOperationPermission(CubeInstance cube) {
        this.aclUtil.hasProjectOperationPermission(cube.getProjectInstance());
    }

    public void checkProjectReadPermission(JobInstance job) {
        this.aclUtil.hasProjectReadPermission(this.getProjectByJob(job));
    }

    public void checkProjectWritePermission(JobInstance job) {
        this.aclUtil.hasProjectWritePermission(this.getProjectByJob(job));
    }

    public void checkProjectOperationPermission(JobInstance job) {
        this.aclUtil.hasProjectOperationPermission(this.getProjectByJob(job));
    }

    public String getCurrentUserName() {
        return this.aclUtil.getCurrentUserName();
    }

    public boolean hasCubeReadPermission(CubeInstance cube) {
        return this.hasProjectReadPermission(cube.getProjectInstance());
    }

    public boolean hasProjectReadPermission(ProjectInstance project) {
        boolean _hasProjectReadPermission = false;
        try {
            _hasProjectReadPermission = this.aclUtil.hasProjectReadPermission(project);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        return _hasProjectReadPermission;
    }

    public boolean hasProjectOperationPermission(ProjectInstance project) {
        boolean _hasProjectOperationPermission = false;
        try {
            _hasProjectOperationPermission = this.aclUtil.hasProjectOperationPermission(project);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        return _hasProjectOperationPermission;
    }

    public boolean hasProjectWritePermission(ProjectInstance project) {
        boolean _hasProjectWritePermission = false;
        try {
            _hasProjectWritePermission = this.aclUtil.hasProjectWritePermission(project);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        return _hasProjectWritePermission;
    }

    public boolean hasProjectAdminPermission(ProjectInstance project) {
        boolean _hasProjectAdminPermission = false;
        try {
            _hasProjectAdminPermission = this.aclUtil.hasProjectAdminPermission(project);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        return _hasProjectAdminPermission;
    }

    public void checkIsGlobalAdmin() {
        this.aclUtil.checkIsGlobalAdmin();
    }
}

