/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCmdStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(HiveCmdStep.class);
    private final PatternedLogger stepLogger = new PatternedLogger(logger);

    protected void createFlatHiveTable(KylinConfig config) throws IOException {
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.overwriteHiveProps(config.getHiveConfigOverride());
        hiveCmdBuilder.addStatement(this.getCmd());
        String cmd = hiveCmdBuilder.toString();
        this.stepLogger.log("cmd: ");
        this.stepLogger.log(cmd);
        Pair<Integer, String> response = config.getCliCommandExecutor().execute(cmd, this.stepLogger);
        this.getManager().addJobInfo(this.getId(), this.stepLogger.getInfo());
        if (response.getFirst() != 0) {
            throw new RuntimeException("Failed to create flat hive table, error code " + response.getFirst());
        }
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        try {
            this.createFlatHiveTable(config);
            return new ExecuteResult(ExecuteResult.State.SUCCEED, this.stepLogger.getBufferedLog());
        }
        catch (Exception e) {
            logger.error("job:" + this.getId() + " execute finished with exception", e);
            return new ExecuteResult(ExecuteResult.State.ERROR, this.stepLogger.getBufferedLog(), e);
        }
    }

    public void setCmd(String sql) {
        this.setParam("cmd", sql);
    }

    public String getCmd() {
        return this.getParam("cmd");
    }
}

