/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.spark.ISparkInput;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.ISampleDataDeployer;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourcePartition;
import org.apache.kylin.source.jdbc.JdbcExplorer;
import org.apache.kylin.source.jdbc.JdbcHiveMRInput;
import org.apache.kylin.source.jdbc.JdbcHiveSparkInput;
import org.apache.kylin.source.jdbc.JdbcTable;

public class JdbcSource
implements ISource {
    private final KylinConfig config;

    public JdbcSource(KylinConfig config) {
        this.config = config;
    }

    @Override
    public ISourceMetadataExplorer getSourceMetadataExplorer() {
        return new JdbcExplorer(this.config);
    }

    @Override
    public <I> I adaptToBuildEngine(Class<I> engineInterface) {
        if (engineInterface == IMRInput.class) {
            return (I)new JdbcHiveMRInput();
        }
        if (engineInterface == ISparkInput.class) {
            return (I)new JdbcHiveSparkInput();
        }
        throw new RuntimeException("Cannot adapt to " + engineInterface);
    }

    @Override
    public IReadableTable createReadableTable(TableDesc tableDesc, String uuid) {
        return new JdbcTable(tableDesc);
    }

    @Override
    public SourcePartition enrichSourcePartitionBeforeBuild(IBuildable buildable, SourcePartition srcPartition) {
        SourcePartition result = SourcePartition.getCopyOf(srcPartition);
        result.setSegRange(null);
        return result;
    }

    @Override
    public ISampleDataDeployer getSampleDataDeployer() {
        return new JdbcExplorer(this.config);
    }

    @Override
    public void unloadTable(String tableName, String project) throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

