/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.MapReduceUtil;
import org.apache.kylin.engine.mr.steps.HiveToBaseCuboidMapper;
import org.apache.kylin.engine.mr.steps.InMemCuboidMapper;
import org.apache.kylin.engine.mr.steps.MergeCuboidJob;
import org.apache.kylin.engine.mr.steps.NDCuboidMapper;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.storage.hbase.steps.HBaseJobSteps;
import org.apache.kylin.storage.hbase.steps.HBaseMRSteps;
import org.apache.kylin.storage.hbase.steps.HBaseSparkSteps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseMROutput2Transition
implements IMROutput2 {
    private static final Logger logger = LoggerFactory.getLogger(HBaseMROutput2Transition.class);

    @Override
    public IMROutput2.IMRBatchCubingOutputSide2 getBatchCubingOutputSide(final CubeSegment seg) {
        boolean useSpark = seg.getCubeDesc().getEngineType() == 4;
        final HBaseJobSteps steps = useSpark ? new HBaseSparkSteps(seg) : new HBaseMRSteps(seg);
        return new IMROutput2.IMRBatchCubingOutputSide2(){

            @Override
            public void addStepPhase2_BuildDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(steps.createCreateHTableStep(jobFlow.getId()));
            }

            @Override
            public void addStepPhase3_BuildCube(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                if (seg.getConfig().isHFileDistCP()) {
                    jobFlow.addTask(steps.createDistcpHFileStep(jobFlow.getId()));
                }
                jobFlow.addTask(steps.createBulkLoadStep(jobFlow.getId()));
            }

            @Override
            public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
                steps.addCubingGarbageCollectionSteps(jobFlow);
            }

            @Override
            public IMROutput2.IMROutputFormat getOutputFormat() {
                return new HBaseMROutputFormat();
            }
        };
    }

    @Override
    public IMROutput2.IMRBatchMergeOutputSide2 getBatchMergeOutputSide(final CubeSegment seg) {
        return new IMROutput2.IMRBatchMergeOutputSide2(){
            HBaseMRSteps steps;
            {
                this.steps = new HBaseMRSteps(seg);
            }

            @Override
            public void addStepPhase1_MergeDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(this.steps.createCreateHTableStep(jobFlow.getId()));
            }

            @Override
            public void addStepPhase2_BuildCube(CubeSegment seg2, List<CubeSegment> mergingSegments, DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(this.steps.createMergeCuboidDataStep(seg2, mergingSegments, jobFlow.getId(), MergeCuboidJob.class));
                jobFlow.addTask(this.steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                if (seg2.getConfig().isHFileDistCP()) {
                    jobFlow.addTask(this.steps.createDistcpHFileStep(jobFlow.getId()));
                }
                jobFlow.addTask(this.steps.createBulkLoadStep(jobFlow.getId()));
            }

            @Override
            public void addStepPhase3_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addMergingGarbageCollectionSteps(jobFlow);
            }

            @Override
            public IMROutput2.IMRMergeOutputFormat getOutputFormat() {
                return new HBaseMergeMROutputFormat();
            }
        };
    }

    @Override
    public IMROutput2.IMRBatchOptimizeOutputSide2 getBatchOptimizeOutputSide(final CubeSegment seg) {
        return new IMROutput2.IMRBatchOptimizeOutputSide2(){
            HBaseMRSteps steps;
            {
                this.steps = new HBaseMRSteps(seg);
            }

            @Override
            public void addStepPhase2_CreateHTable(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(this.steps.createCreateHTableStep(jobFlow.getId(), CuboidModeEnum.RECOMMEND));
            }

            @Override
            public void addStepPhase3_BuildCube(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(this.steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                if (seg.getConfig().isHFileDistCP()) {
                    jobFlow.addTask(this.steps.createDistcpHFileStep(jobFlow.getId()));
                }
                jobFlow.addTask(this.steps.createBulkLoadStep(jobFlow.getId()));
            }

            @Override
            public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addOptimizeGarbageCollectionSteps(jobFlow);
            }

            @Override
            public void addStepPhase5_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addCheckpointGarbageCollectionSteps(jobFlow);
            }
        };
    }

    public static class HBaseMergeMROutputFormat
    implements IMROutput2.IMRMergeOutputFormat {
        @Override
        public void configureJobInput(Job job, String input) throws Exception {
            job.setInputFormatClass(SequenceFileInputFormat.class);
        }

        @Override
        public void configureJobOutput(Job job, String output, CubeSegment segment) throws Exception {
            int reducerNum = MapReduceUtil.getLayeredCubingReduceTaskNum(segment, segment.getCuboidScheduler(), AbstractHadoopJob.getTotalMapInputMB(job), -1);
            job.setNumReduceTasks(reducerNum);
            Path outputPath = new Path(output);
            HadoopUtil.deletePath(job.getConfiguration(), outputPath);
            FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
        }

        @Override
        public CubeSegment findSourceSegment(FileSplit fileSplit, CubeInstance cube) {
            String filePath = fileSplit.getPath().toString();
            String jobID = JobBuilderSupport.extractJobIDFromPath(filePath);
            return CubeInstance.findSegmentWithJobId(jobID, cube);
        }
    }

    public static class HBaseMROutputFormat
    implements IMROutput2.IMROutputFormat {
        @Override
        public void configureJobInput(Job job, String input) throws Exception {
            job.setInputFormatClass(SequenceFileInputFormat.class);
        }

        @Override
        public void configureJobOutput(Job job, String output, CubeSegment segment, CuboidScheduler cuboidScheduler, int level) throws Exception {
            int reducerNum = 1;
            Class mapperClass = job.getMapperClass();
            if (mapperClass == HiveToBaseCuboidMapper.class) {
                for (Map.Entry<String, String> entry : segment.getConfig().getBaseCuboidMRConfigOverride().entrySet()) {
                    job.getConfiguration().set(entry.getKey(), entry.getValue());
                }
            }
            if (mapperClass == HiveToBaseCuboidMapper.class || mapperClass == NDCuboidMapper.class) {
                reducerNum = MapReduceUtil.getLayeredCubingReduceTaskNum(segment, cuboidScheduler, AbstractHadoopJob.getTotalMapInputMB(job), level);
            } else if (mapperClass == InMemCuboidMapper.class) {
                reducerNum = MapReduceUtil.getInmemCubingReduceTaskNum(segment, cuboidScheduler);
            }
            Path outputPath = new Path(output);
            FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
            job.setNumReduceTasks(reducerNum);
            HadoopUtil.deletePath(job.getConfiguration(), outputPath);
        }
    }
}

