/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.util.Collections;
import java.util.List;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.hadoop.util.ZKUtil;
import org.apache.kylin.common.KylinConfig;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperAclBuilder {
    private static Logger logger = LoggerFactory.getLogger(ZookeeperAclBuilder.class);
    private List<ACL> zkAcls;
    private List<ZKUtil.ZKAuthInfo> zkAuthInfo;
    private boolean isNeedAcl = KylinConfig.getInstanceFromEnv().isZookeeperAclEnabled();

    public CuratorFrameworkFactory.Builder setZKAclBuilder(CuratorFrameworkFactory.Builder builder) {
        if (!this.isNeedAcl()) {
            return builder;
        }
        ACLProvider aclProvider = new ACLProvider(){
            private List<ACL> acl;

            public List<ACL> getDefaultAcl() {
                if (this.acl == null) {
                    this.acl = ZookeeperAclBuilder.this.zkAcls;
                }
                return this.acl;
            }

            public List<ACL> getAclForPath(String path) {
                return this.acl;
            }
        };
        CuratorFrameworkFactory.Builder aclBuilder = builder.aclProvider(aclProvider);
        for (ZKUtil.ZKAuthInfo auth : this.zkAuthInfo) {
            aclBuilder = aclBuilder.authorization(auth.getScheme(), auth.getAuth());
        }
        return aclBuilder;
    }

    public ZookeeperAclBuilder invoke() {
        try {
            if (this.isNeedAcl()) {
                this.zkAcls = ZookeeperAclBuilder.getZKAcls();
                this.zkAuthInfo = ZookeeperAclBuilder.getZKAuths();
            }
        }
        catch (Exception e) {
            this.isNeedAcl = false;
            return this;
        }
        return this;
    }

    public static List<ZKUtil.ZKAuthInfo> getZKAuths() throws Exception {
        String zkAuthConf = KylinConfig.getInstanceFromEnv().getZKAuths();
        try {
            zkAuthConf = ZKUtil.resolveConfIndirection((String)zkAuthConf);
            if (zkAuthConf != null) {
                return ZKUtil.parseAuth((String)zkAuthConf);
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            logger.error("Couldn't read Auth based on 'kylin.env.zookeeper.zk-auth' in kylin.properties");
            throw e;
        }
    }

    public static List<ACL> getZKAcls() throws Exception {
        String zkAclConf = KylinConfig.getInstanceFromEnv().getZKAcls();
        try {
            zkAclConf = ZKUtil.resolveConfIndirection((String)zkAclConf);
            return ZKUtil.parseACLs((String)zkAclConf);
        }
        catch (Exception e) {
            logger.error("Couldn't read ACLs based on 'kylin.env.zookeeper.zk-acl' in kylin.properties");
            throw e;
        }
    }

    public boolean isNeedAcl() {
        return this.isNeedAcl;
    }
}

