/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.CompoundTupleIterator;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.gtrecord.CubeSegmentScanner;
import org.apache.kylin.storage.gtrecord.GTCubeStorageQueryRequest;
import org.apache.kylin.storage.gtrecord.SequentialCubeTupleIterator;
import org.apache.kylin.storage.hbase.cube.v2.CubeStorageQuery;
import org.apache.kylin.storage.stream.rpc.IStreamDataSearchClient;
import org.apache.kylin.stream.core.query.StreamingDataQueryPlanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamStorageQuery
extends CubeStorageQuery {
    private static final Logger logger = LoggerFactory.getLogger(StreamStorageQuery.class);
    private final IStreamDataSearchClient realTimeSearchClient;

    public StreamStorageQuery(CubeInstance cube, IStreamDataSearchClient realTimeSearchClient) {
        super(cube);
        this.realTimeSearchClient = realTimeSearchClient;
    }

    @Override
    public ITupleIterator search(StorageContext context, SQLDigest sqlDigest, TupleInfo returnTupleInfo) {
        ITupleIterator realTimeResult;
        GTCubeStorageQueryRequest request = this.getStorageQueryRequest(context, sqlDigest, returnTupleInfo);
        ArrayList<CubeSegmentScanner> scanners = Lists.newArrayList();
        long maxHistorySegmentTime = -1L;
        StreamingDataQueryPlanner segmentsPlanner = new StreamingDataQueryPlanner(this.cubeInstance.getDescriptor(), request.getFilter());
        long current = System.currentTimeMillis();
        for (CubeSegment cubeSeg : this.cubeInstance.getSegments(SegmentStatusEnum.READY)) {
            SegmentRange.TSRange segmentRange = cubeSeg.getTSRange();
            if ((Long)segmentRange.end.v > maxHistorySegmentTime && (Long)cubeSeg.getTSRange().end.v < current) {
                maxHistorySegmentTime = (Long)cubeSeg.getTSRange().end.v;
            }
            if (this.cubeDesc.getConfig().isSkippingEmptySegments() && cubeSeg.getInputRecords() == 0L) {
                logger.info("Skip cube segment {} because its input record is 0", (Object)cubeSeg);
                continue;
            }
            if (segmentsPlanner.canSkip((Long)segmentRange.start.v, (Long)segmentRange.end.v)) {
                logger.info("Skip cube segment {} because of not satisfy filter:{}", (Object)cubeSeg, (Object)request.getFilter());
                continue;
            }
            CubeSegmentScanner scanner = new CubeSegmentScanner(cubeSeg, request.getCuboid(), request.getDimensions(), request.getGroups(), request.getDynGroups(), request.getDynGroupExprs(), request.getMetrics(), request.getDynFuncs(), request.getFilter(), request.getHavingFilter(), request.getContext());
            if (scanner.isSegmentSkipped()) continue;
            scanners.add(scanner);
        }
        ITupleIterator historyResult = scanners.isEmpty() ? ITupleIterator.EMPTY_TUPLE_ITERATOR : new SequentialCubeTupleIterator(scanners, request.getCuboid(), request.getDimensions(), request.getDynGroups(), request.getGroups(), request.getMetrics(), returnTupleInfo, context, sqlDigest);
        Set<TblColRef> dimensionsD = request.getDimensions();
        if (dimensionsD.isEmpty()) {
            dimensionsD = Sets.newHashSet(request.getCuboid().getColumns());
        }
        if (segmentsPlanner.canSkip(maxHistorySegmentTime, Long.MAX_VALUE)) {
            logger.info("Skip scan realTime data, {}", (Object)maxHistorySegmentTime);
            realTimeResult = ITupleIterator.EMPTY_TUPLE_ITERATOR;
        } else {
            boolean isSelectAllQuery = this.isSelectAllQuery(request.getCuboid(), request.getGroups(), request.getFilter());
            int limitPushDown = isSelectAllQuery ? context.getFinalPushDownLimit() : Integer.MAX_VALUE;
            realTimeResult = this.realTimeSearchClient.search(maxHistorySegmentTime, this.cubeInstance, returnTupleInfo, request.getFilter(), dimensionsD, request.getGroups(), request.getMetrics(), limitPushDown, !isSelectAllQuery);
        }
        return new CompoundTupleIterator(Arrays.asList(historyResult, realTimeResult));
    }

    private boolean isSelectAllQuery(Cuboid cuboid, Set<TblColRef> groupsD, TupleFilter filterD) {
        return Cuboid.getBaseCuboidId(this.cubeDesc) == cuboid.getId() && filterD == null && cuboid.getColumns().size() == groupsD.size();
    }
}

