/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.curator.shaded.com.google.common.base.Strings;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.source.MessageParserInfo;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class StreamingSourceConfig
extends RootPersistentEntity {
    private static final long serialVersionUID = 4931334770020441831L;
    public static Serializer<StreamingSourceConfig> SERIALIZER = new JsonSerializer<StreamingSourceConfig>(StreamingSourceConfig.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="parser_info")
    private MessageParserInfo parserInfo;
    @JsonProperty(value="properties")
    private Map<String, String> properties = Maps.newLinkedHashMap();
    @JsonProperty(value="project_name")
    private String projectName;

    @Deprecated
    static String concatResourcePath(String name) {
        return "/streaming_v2/" + name + ".json";
    }

    public static String concatResourcePathWithProjName(String name, String projectName) {
        if (Strings.isNullOrEmpty((String)projectName)) {
            return StreamingSourceConfig.concatResourcePath(name);
        }
        return "/streaming_v2/" + name + "--" + projectName + ".json";
    }

    public String getResourcePathWithProjName() {
        return StreamingSourceConfig.concatResourcePathWithProjName(this.name, this.projectName);
    }

    @Deprecated
    public String getResourcePath() {
        return StreamingSourceConfig.concatResourcePath(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public MessageParserInfo getParserInfo() {
        return this.parserInfo;
    }

    public void setParserInfo(MessageParserInfo parserInfo) {
        this.parserInfo = parserInfo;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public StreamingSourceConfig clone() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SERIALIZER.serialize(this, new DataOutputStream(baos));
            return SERIALIZER.deserialize(new DataInputStream(new ByteArrayInputStream(baos.toByteArray())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

