/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataReader;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataWriter;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncoding;
import org.apache.kylin.stream.core.storage.columnar.FSInputGeneralColumnDataReader;
import org.apache.kylin.stream.core.storage.columnar.GeneralColumnDataReader;
import org.apache.kylin.stream.core.storage.columnar.GeneralColumnDataWriter;
import org.apache.kylin.stream.core.storage.columnar.compress.Compression;
import org.apache.kylin.stream.core.storage.columnar.compress.FSInputLZ4CompressedColumnReader;
import org.apache.kylin.stream.core.storage.columnar.compress.FSInputNoCompressedColumnReader;
import org.apache.kylin.stream.core.storage.columnar.compress.LZ4CompressedColumnReader;
import org.apache.kylin.stream.core.storage.columnar.compress.LZ4CompressedColumnWriter;
import org.apache.kylin.stream.core.storage.columnar.compress.NoCompressedColumnReader;
import org.apache.kylin.stream.core.storage.columnar.compress.NoCompressedColumnWriter;

public class ColumnarStoreMetricsDesc {
    private int fixLen = -1;
    private Compression compression;

    public static ColumnarStoreMetricsDesc getDefaultCStoreMetricsDesc(ColumnarMetricsEncoding metricsEncoding) {
        return new ColumnarStoreMetricsDesc(metricsEncoding, Compression.LZ4);
    }

    public ColumnarStoreMetricsDesc(ColumnarMetricsEncoding metricsEncoding, Compression compression) {
        if (metricsEncoding.isFixLength()) {
            this.fixLen = metricsEncoding.getFixLength();
        }
        this.compression = compression;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public ColumnDataWriter getMetricsWriter(OutputStream output, int rowCnt) {
        if (this.compression == Compression.LZ4 && this.fixLen != -1) {
            return new LZ4CompressedColumnWriter(this.fixLen, rowCnt, 65536, output);
        }
        if (this.fixLen != -1) {
            return new NoCompressedColumnWriter(output);
        }
        return new GeneralColumnDataWriter(rowCnt, new DataOutputStream(output));
    }

    public ColumnDataReader getMetricsReader(ByteBuffer dataBuffer, int columnDataStartOffset, int columnDataLength, int rowCount) {
        if (Compression.LZ4 == this.compression && this.fixLen != -1) {
            return new LZ4CompressedColumnReader(dataBuffer, columnDataStartOffset, columnDataLength, rowCount);
        }
        if (this.fixLen != -1) {
            return new NoCompressedColumnReader(dataBuffer, columnDataStartOffset, columnDataLength / rowCount, rowCount);
        }
        return new GeneralColumnDataReader(dataBuffer, columnDataStartOffset, columnDataLength);
    }

    public ColumnDataReader getMetricsReaderFromFSInput(FileSystem fs, Path filePath, int columnDataStartOffset, int columnDataLength, int rowCount) throws IOException {
        if (Compression.LZ4 == this.compression && this.fixLen != -1) {
            return new FSInputLZ4CompressedColumnReader(fs, filePath, columnDataStartOffset, columnDataLength, rowCount);
        }
        if (this.fixLen != -1) {
            return new FSInputNoCompressedColumnReader(fs, filePath, columnDataStartOffset, columnDataLength / rowCount, rowCount);
        }
        return new FSInputGeneralColumnDataReader(fs, filePath, columnDataStartOffset, columnDataLength);
    }
}

