/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataReader;

public class FSInputGeneralColumnDataReader
implements ColumnDataReader {
    private FSDataInputStream fsInputStream;
    private int numOfVals;

    public FSInputGeneralColumnDataReader(FileSystem fs, Path file, int dataStartOffset, int dataLength) throws IOException {
        this.fsInputStream = fs.open(file);
        this.fsInputStream.seek((long)(dataStartOffset + dataLength) - 4L);
        this.numOfVals = this.fsInputStream.readInt();
        this.fsInputStream.seek((long)dataStartOffset);
    }

    @Override
    public byte[] read(int index) {
        throw new UnsupportedOperationException("not support to read row operation");
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            int readRowCount = 0;

            @Override
            public boolean hasNext() {
                return this.readRowCount < FSInputGeneralColumnDataReader.this.numOfVals;
            }

            @Override
            public byte[] next() {
                try {
                    int size = FSInputGeneralColumnDataReader.this.fsInputStream.readInt();
                    byte[] result = new byte[size];
                    FSInputGeneralColumnDataReader.this.fsInputStream.readFully(result);
                    ++this.readRowCount;
                    return result;
                }
                catch (IOException e) {
                    throw new NoSuchElementException("error when read data");
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("unSupport operation");
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.fsInputStream.close();
    }
}

