/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.ZipFileUtils;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMetaIngester
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(CubeMetaIngester.class);
    private static final Option OPTION_SRC;
    private static final Option OPTION_PROJECT;
    private static final Option OPTION_FORCE_INGEST;
    private static final Option OPTION_OVERWRITE_TABLES;
    private static final Option OPTION_CREATE_PROJECT;
    private KylinConfig kylinConfig;
    Set<String> requiredResources = Sets.newLinkedHashSet();
    private String targetProjectName;
    private boolean overwriteTables = false;
    private boolean forceIngest = false;
    private boolean createProjectIfNotExists = false;

    @Override
    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_SRC);
        options.addOption(OPTION_PROJECT);
        options.addOption(OPTION_FORCE_INGEST);
        options.addOption(OPTION_OVERWRITE_TABLES);
        options.addOption(OPTION_CREATE_PROJECT);
        return options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        if (optionsHelper.hasOption(OPTION_FORCE_INGEST)) {
            this.forceIngest = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_FORCE_INGEST));
        }
        if (optionsHelper.hasOption(OPTION_OVERWRITE_TABLES)) {
            this.overwriteTables = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_OVERWRITE_TABLES));
        }
        if (optionsHelper.hasOption(OPTION_CREATE_PROJECT)) {
            this.createProjectIfNotExists = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_CREATE_PROJECT));
        }
        this.targetProjectName = optionsHelper.getOptionValue(OPTION_PROJECT);
        String srcPath = optionsHelper.getOptionValue(OPTION_SRC);
        if (!srcPath.endsWith(".zip")) {
            throw new IllegalArgumentException(OPTION_SRC.getArgName() + " has to be a zip file");
        }
        File zipFile = new File(srcPath);
        if (zipFile.isDirectory() || !zipFile.exists()) {
            throw new IllegalArgumentException(OPTION_SRC.getArgName() + " file does not exist");
        }
        Path tempPath = Files.createTempDirectory("_unzip", new FileAttribute[0]);
        File tempFolder = tempPath.toFile();
        tempFolder.deleteOnExit();
        ZipFileUtils.decompressZipfileToDirectory(srcPath, tempFolder);
        if (tempFolder.list().length != 1) {
            throw new IllegalStateException(Arrays.toString(tempFolder.list()));
        }
        this.injest(tempFolder.listFiles()[0].getAbsoluteFile());
    }

    private void injest(File metaRoot) throws IOException {
        KylinConfig srcConfig = KylinConfig.createInstanceFromUri(metaRoot.getAbsolutePath());
        TableMetadataManager srcMetadataManager = TableMetadataManager.getInstance(srcConfig);
        DataModelManager srcModelManager = DataModelManager.getInstance(srcConfig);
        HybridManager srcHybridManager = HybridManager.getInstance(srcConfig);
        CubeManager srcCubeManager = CubeManager.getInstance(srcConfig);
        CubeDescManager srcCubeDescManager = CubeDescManager.getInstance(srcConfig);
        this.checkAndMark(srcMetadataManager, srcModelManager, srcHybridManager, srcCubeManager, srcCubeDescManager);
        new ResourceTool().copy(srcConfig, this.kylinConfig, Lists.newArrayList(this.requiredResources));
        Broadcaster.getInstance(this.kylinConfig).notifyClearAll();
        ProjectManager projectManager = ProjectManager.getInstance(this.kylinConfig);
        for (TableDesc tableDesc : srcMetadataManager.listAllTables(null)) {
            logger.info("add " + tableDesc + " to " + this.targetProjectName);
            projectManager.addTableDescToProject(Lists.newArrayList(tableDesc.getIdentity()).toArray(new String[0]), this.targetProjectName);
        }
        for (CubeInstance cube : srcCubeManager.listAllCubes()) {
            logger.info("add " + cube + " to " + this.targetProjectName);
            projectManager.addModelToProject(cube.getModel().getName(), this.targetProjectName);
            srcModelManager.reloadDataModel(cube.getModel().getName());
            projectManager.moveRealizationToProject(RealizationType.CUBE, cube.getName(), this.targetProjectName, null);
        }
    }

    private void checkAndMark(TableMetadataManager srcMetadataManager, DataModelManager srcModelManager, HybridManager srcHybridManager, CubeManager srcCubeManager, CubeDescManager srcCubeDescManager) throws IOException {
        if (srcHybridManager.listHybridInstances().size() > 0) {
            throw new IllegalStateException("Does not support ingest hybrid yet");
        }
        ProjectManager projectManager = ProjectManager.getInstance(this.kylinConfig);
        ProjectInstance targetProject = projectManager.getProject(this.targetProjectName);
        if (targetProject == null) {
            if (this.createProjectIfNotExists) {
                projectManager.createProject(this.targetProjectName, null, "This is a project automatically added when ingest cube", null);
            } else {
                throw new IllegalStateException("Target project does not exist in target metadata: " + this.targetProjectName);
            }
        }
        TableMetadataManager metadataManager = TableMetadataManager.getInstance(this.kylinConfig);
        for (TableDesc tableDesc : srcMetadataManager.listAllTables(null)) {
            TableDesc tableDesc2 = metadataManager.getTableDesc(tableDesc.getIdentity(), this.targetProjectName);
            if (tableDesc2 != null && !tableDesc2.equals(tableDesc)) {
                logger.info("Table {} already has a different version in target metadata store", (Object)tableDesc.getIdentity());
                logger.info("Existing version: {}", (Object)tableDesc2);
                logger.info("New version: {}", (Object)tableDesc);
                if (!this.forceIngest && !this.overwriteTables) {
                    throw new IllegalStateException("table already exists with a different version: " + tableDesc.getIdentity() + ". Consider adding -overwriteTables option to force overwriting (with caution)");
                }
                logger.warn("Overwriting the old table desc: {}", (Object)tableDesc.getIdentity());
            }
            if (tableDesc2 == null) {
                tableDesc.setUuid(RandomUtil.randomUUID().toString());
                tableDesc.setLastModified(0L);
                metadataManager.saveSourceTable(tableDesc, this.targetProjectName);
            }
            this.requiredResources.add(tableDesc.getResourcePath());
        }
        DataModelManager modelManager = DataModelManager.getInstance(this.kylinConfig);
        for (DataModelDesc dataModelDesc : srcModelManager.listDataModels()) {
            this.checkExisting(modelManager.getDataModelDesc(dataModelDesc.getName()), "model", dataModelDesc.getName());
            this.requiredResources.add(DataModelDesc.concatResourcePath(dataModelDesc.getName()));
        }
        CubeDescManager cubeDescManager = CubeDescManager.getInstance(this.kylinConfig);
        for (CubeDesc cubeDesc : srcCubeDescManager.listAllDesc()) {
            this.checkExisting(cubeDescManager.getCubeDesc(cubeDesc.getName()), "cube desc", cubeDesc.getName());
            this.requiredResources.add(CubeDesc.concatResourcePath(cubeDesc.getName()));
        }
        CubeManager cubeManager = CubeManager.getInstance(this.kylinConfig);
        for (CubeInstance cube : srcCubeManager.listAllCubes()) {
            this.checkExisting(cubeManager.getCube(cube.getName()), "cube", cube.getName());
            this.requiredResources.add(CubeInstance.concatResourcePath(cube.getName()));
        }
    }

    private void checkExisting(RootPersistentEntity existing, String type, String name) {
        if (existing != null) {
            if (!this.forceIngest) {
                throw new IllegalStateException("Already exist a " + type + " called " + name);
            }
            logger.warn("Overwriting the old {} desc: {}", (Object)type, (Object)name);
        }
    }

    public static void main(String[] args) {
        CubeMetaIngester extractor = new CubeMetaIngester();
        extractor.execute(args);
    }

    static {
        OptionBuilder.withArgName((String)"srcPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"specify the path to the extracted cube metadata zip file");
        OPTION_SRC = OptionBuilder.create((String)"srcPath");
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"specify the target project for the new cubes");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"forceIngest");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"skip the target cube, model and table check and ingest by force. Use in caution because it might break existing cubes! Suggest to backup metadata store first");
        OPTION_FORCE_INGEST = OptionBuilder.create((String)"forceIngest");
        OptionBuilder.withArgName((String)"overwriteTables");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"If table meta conflicts, overwrite the one in metadata store with the one in srcPath. Use in caution because it might break existing cubes! Suggest to backup metadata store first");
        OPTION_OVERWRITE_TABLES = OptionBuilder.create((String)"overwriteTables");
        OptionBuilder.withArgName((String)"createProjectIfNotExists");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"If project is not exists, kylin will create it.");
        OPTION_CREATE_PROJECT = OptionBuilder.create((String)"createProjectIfNotExists");
    }
}

