/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.migration;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DictionaryDesc;
import org.apache.kylin.cube.model.SnapshotTableDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.GlobalDictionaryBuilder;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.rest.response.HBaseResponse;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.HBaseInfoUtil;
import org.apache.kylin.rest.service.KylinUserService;
import org.apache.kylin.rest.service.update.TableSchemaUpdateMapping;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.tool.migration.DstClusterUtil;
import org.apache.kylin.tool.migration.SrcClusterUtil;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMigrationCrossClusterCLI
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(CubeMigrationCrossClusterCLI.class);
    public static final Option OPTION_KYLIN_URI_SRC;
    public static final Option OPTION_KYLIN_URI_DST;
    public static final Option OPTION_UPDATE_MAPPING;
    public static final Option OPTION_CUBE;
    public static final Option OPTION_HYBRID;
    public static final Option OPTION_PROJECT;
    public static final Option OPTION_All;
    public static final Option OPTION_DST_HIVE_CHECK;
    public static final Option OPTION_OVERWRITE;
    public static final Option OPTION_SCHEMA_ONLY;
    public static final Option OPTION_EXECUTE;
    public static final Option OPTION_COPROCESSOR_PATH;
    public static final Option OPTION_FS_HA_ENABLED_CODE;
    public static final Option OPTION_DISTCP_JOB_QUEUE;
    public static final Option OPTION_DISTCP_JOB_MEMORY;
    public static final Option OPTION_THREAD_NUM;
    protected final Options options;
    private Configuration distCpConf;
    protected SrcClusterUtil srcCluster;
    protected DstClusterUtil dstCluster;
    private int codeOfFSHAEnabled = 3;
    protected int nThread;
    private boolean ifDstHiveCheck = true;
    private boolean ifSchemaOnly = true;
    private boolean ifExecute = false;
    private boolean ifOverwrite = false;
    private String coprocessorJarPath;
    private Set<CubeInstance> cubes = Sets.newHashSet();
    private Set<HybridInstance> hybrids = Sets.newHashSet();
    private Set<ProjectInstance> projects = Sets.newHashSet();
    private Map<String, TableSchemaUpdateMapping> mappings = Maps.newHashMap();
    private Map<String, ProjectInstance> dstProjects = Maps.newHashMap();

    public CubeMigrationCrossClusterCLI() {
        OptionGroup realizationOrProject = new OptionGroup();
        realizationOrProject.addOption(OPTION_CUBE);
        realizationOrProject.addOption(OPTION_HYBRID);
        realizationOrProject.addOption(OPTION_PROJECT);
        realizationOrProject.addOption(OPTION_All);
        realizationOrProject.setRequired(true);
        this.options = new Options();
        this.options.addOption(OPTION_KYLIN_URI_SRC);
        this.options.addOption(OPTION_KYLIN_URI_DST);
        this.options.addOption(OPTION_FS_HA_ENABLED_CODE);
        this.options.addOption(OPTION_UPDATE_MAPPING);
        this.options.addOptionGroup(realizationOrProject);
        this.options.addOption(OPTION_DST_HIVE_CHECK);
        this.options.addOption(OPTION_SCHEMA_ONLY);
        this.options.addOption(OPTION_OVERWRITE);
        this.options.addOption(OPTION_EXECUTE);
        this.options.addOption(OPTION_COPROCESSOR_PATH);
        this.options.addOption(OPTION_DISTCP_JOB_QUEUE);
        this.options.addOption(OPTION_THREAD_NUM);
        this.options.addOption(OPTION_DISTCP_JOB_MEMORY);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    public static boolean ifFSHAEnabled(int code, int pos) {
        int which = 1 << pos;
        return (code & which) == which;
    }

    protected void init(OptionsHelper optionsHelper) throws Exception {
        if (optionsHelper.hasOption(OPTION_UPDATE_MAPPING)) {
            File mappingFile = new File(optionsHelper.getOptionValue(OPTION_UPDATE_MAPPING));
            String content = new String(Files.readAllBytes(mappingFile.toPath()), Charset.defaultCharset());
            Map<String, TableSchemaUpdateMapping> tmpMappings = JsonUtil.readValue(content, new TypeReference<Map<String, TableSchemaUpdateMapping>>(){});
            this.mappings = Maps.newHashMapWithExpectedSize((int)tmpMappings.size());
            for (Map.Entry<String, TableSchemaUpdateMapping> entry : tmpMappings.entrySet()) {
                this.mappings.put(entry.getKey().toUpperCase(Locale.ROOT), entry.getValue());
            }
        }
        this.ifDstHiveCheck = optionsHelper.hasOption(OPTION_DST_HIVE_CHECK) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_DST_HIVE_CHECK)) : true;
        this.ifSchemaOnly = optionsHelper.hasOption(OPTION_SCHEMA_ONLY) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_SCHEMA_ONLY)) : true;
        this.ifOverwrite = optionsHelper.hasOption(OPTION_OVERWRITE) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_OVERWRITE)) : false;
        this.ifExecute = optionsHelper.hasOption(OPTION_EXECUTE) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_EXECUTE)) : false;
        this.codeOfFSHAEnabled = optionsHelper.hasOption(OPTION_FS_HA_ENABLED_CODE) ? Integer.valueOf(optionsHelper.getOptionValue(OPTION_FS_HA_ENABLED_CODE)) : 3;
        String srcConfigURI = optionsHelper.getOptionValue(OPTION_KYLIN_URI_SRC);
        this.srcCluster = new SrcClusterUtil(srcConfigURI, CubeMigrationCrossClusterCLI.ifFSHAEnabled(this.codeOfFSHAEnabled, 0), CubeMigrationCrossClusterCLI.ifFSHAEnabled(this.codeOfFSHAEnabled, 1));
        String dstConfigURI = optionsHelper.getOptionValue(OPTION_KYLIN_URI_DST);
        this.dstCluster = new DstClusterUtil(dstConfigURI, CubeMigrationCrossClusterCLI.ifFSHAEnabled(this.codeOfFSHAEnabled, 2), CubeMigrationCrossClusterCLI.ifFSHAEnabled(this.codeOfFSHAEnabled, 3), this.ifExecute);
        this.distCpConf = new Configuration(this.srcCluster.jobConf);
        if (optionsHelper.hasOption(OPTION_DISTCP_JOB_QUEUE)) {
            this.distCpConf.set("mapreduce.job.queuename", optionsHelper.getOptionValue(OPTION_DISTCP_JOB_QUEUE));
        }
        int distCpMemory = optionsHelper.hasOption(OPTION_DISTCP_JOB_MEMORY) ? Integer.valueOf(optionsHelper.getOptionValue(OPTION_DISTCP_JOB_MEMORY)) : 1500;
        int distCpJVMMemory = distCpMemory * 4 / 5;
        this.distCpConf.set("mapreduce.map.memory.mb", "" + distCpMemory);
        this.distCpConf.set("mapreduce.map.java.opts", "-server -Xmx" + distCpJVMMemory + "m -Djava.net.preferIPv4Stack=true");
        this.nThread = optionsHelper.hasOption(OPTION_THREAD_NUM) ? Integer.valueOf(optionsHelper.getOptionValue(OPTION_THREAD_NUM)) : 8;
        this.coprocessorJarPath = optionsHelper.hasOption(OPTION_COPROCESSOR_PATH) ? optionsHelper.getOptionValue(OPTION_COPROCESSOR_PATH) : this.srcCluster.getDefaultCoprocessorJarPath();
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        this.init(optionsHelper);
        if (optionsHelper.hasOption(OPTION_All)) {
            this.projects.addAll(this.srcCluster.listAllProjects());
        } else if (optionsHelper.hasOption(OPTION_PROJECT)) {
            HashSet projectNames = Sets.newHashSet((Object[])optionsHelper.getOptionValue(OPTION_PROJECT).split(","));
            for (String projectName : projectNames) {
                ProjectInstance project = this.srcCluster.getProject(projectName);
                if (project == null) {
                    throw new IllegalArgumentException("No project found with name of " + projectName);
                }
                this.projects.add(project);
            }
        } else if (optionsHelper.hasOption(OPTION_CUBE)) {
            String cubeNames = optionsHelper.getOptionValue(OPTION_CUBE);
            for (String cubeName : cubeNames.split(",")) {
                CubeInstance cube = this.srcCluster.getCube(cubeName);
                if (cube == null) {
                    throw new IllegalArgumentException("No cube found with name of " + (String)cubeName);
                }
                this.cubes.add(cube);
            }
        } else if (optionsHelper.hasOption(OPTION_HYBRID)) {
            Iterator<HybridInstance> hybridNames = optionsHelper.getOptionValue(OPTION_HYBRID);
            for (String hybridName : ((String)((Object)hybridNames)).split(",")) {
                HybridInstance hybridInstance = this.srcCluster.getHybrid(hybridName);
                if (hybridInstance == null) {
                    throw new IllegalArgumentException("No hybrid found with name of" + (String)hybridName);
                }
                this.hybrids.add(hybridInstance);
            }
        }
        if (!this.projects.isEmpty()) {
            for (ProjectInstance project : this.projects) {
                for (RealizationEntry entry : project.getRealizationEntries()) {
                    IRealization realization = this.srcCluster.getRealization(entry);
                    this.addRealization(realization);
                }
            }
        }
        if (!this.hybrids.isEmpty()) {
            for (HybridInstance hybrid : this.hybrids) {
                this.addHybrid(hybrid);
            }
        }
        HashMap failedCubes = Maps.newHashMap();
        for (CubeInstance cube : this.cubes) {
            logger.info("start to migrate cube {}", (Object)cube);
            try {
                this.migrateCube(cube);
                logger.info("finish migrating cube {}", (Object)cube);
            }
            catch (Exception e) {
                logger.error("fail to migrate cube {} due to ", (Object)cube, (Object)e);
                failedCubes.put(cube, e);
            }
        }
        for (HybridInstance hybrid : this.hybrids) {
            this.dstCluster.saveHybrid(hybrid);
            ProjectInstance srcProject = this.srcCluster.getProjectByRealization(RealizationType.HYBRID, hybrid.getName());
            ProjectInstance dstProject = this.getDstProject(srcProject);
            HashSet projReals = Sets.newHashSet(dstProject.getRealizationEntries());
            projReals.add(RealizationEntry.create(RealizationType.HYBRID, hybrid.getName()));
            dstProject.setRealizationEntries(Lists.newArrayList((Iterable)projReals));
            this.dstProjects.put(dstProject.getName(), dstProject);
        }
        for (String projName : this.dstProjects.keySet()) {
            this.dstCluster.saveProject(this.dstProjects.get(projName));
        }
        this.dstCluster.updateMeta();
        if (failedCubes.isEmpty()) {
            logger.info("Migration for cubes {}, hyrbids {} all succeed", (Object)this.cubes, (Object)this.hybrids);
        } else {
            logger.warn("Failed to migrate cubes {} and need to check the detailed reason and retry again!!!", (Object)failedCubes.keySet());
        }
    }

    /*
     * Exception decompiling
     */
    private void migrateCube(CubeInstance cube) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkGlobalDict(CubeDesc cubeDesc) {
        if (cubeDesc.getDictionaries() != null && !cubeDesc.getDictionaries().isEmpty()) {
            for (DictionaryDesc dictDesc : cubeDesc.getDictionaries()) {
                if (!GlobalDictionaryBuilder.class.getName().equalsIgnoreCase(dictDesc.getBuilderClass())) continue;
                throw new RuntimeException("it's not supported to migrate global dictionaries " + dictDesc + " for cube " + cubeDesc.getName());
            }
        }
    }

    private List<Future<?>> migrateCubeData(CubeInstance cube, CubeDesc cubeDesc, ExecutorService executor) throws IOException {
        LinkedList futureList = Lists.newLinkedList();
        for (final CubeSegment segment : cube.getSegments(SegmentStatusEnum.READY)) {
            logger.info("start to migrate segment: {} {}", (Object)cube, (Object)segment.getName());
            this.copyMetaResource(segment.getStatisticsResourcePath());
            for (String dict : segment.getDictionaryPaths()) {
                this.copyDictionary(cube, dict);
            }
            for (String snapshot : segment.getSnapshotPaths()) {
                this.copySnapshot(cube, snapshot);
            }
            Future<?> future = executor.submit(new MyRunnable(){

                @Override
                public void doRun() throws Exception {
                    CubeMigrationCrossClusterCLI.this.copyHDFSJobInfo(segment.getLastBuildJobID());
                }
            });
            futureList.add(future);
            future = executor.submit(new MyRunnable(){

                @Override
                public void doRun() throws Exception {
                    CubeMigrationCrossClusterCLI.this.copyHTable(segment);
                }
            });
            futureList.add(future);
            logger.info("add segment {} to migration list", (Object)segment);
        }
        if (cubeDesc.getSnapshotTableDescList() != null) {
            for (SnapshotTableDesc snapshotTable : cubeDesc.getSnapshotTableDescList()) {
                if (!snapshotTable.isGlobal()) continue;
                String snapshotResPath = cube.getSnapshotResPath(snapshotTable.getTableName());
                if (snapshotTable.isExtSnapshotTable()) {
                    final ExtTableSnapshotInfo extSnapshot = this.srcCluster.getExtTableSnapshotInfo(snapshotResPath);
                    this.dstCluster.saveExtSnapshotTableInfo(extSnapshot);
                    if ("hbase".equals(extSnapshot.getStorageType())) {
                        Future<?> future = executor.submit(new MyRunnable(){

                            @Override
                            public void doRun() throws Exception {
                                CubeMigrationCrossClusterCLI.this.copyHTable(extSnapshot);
                            }
                        });
                        futureList.add(future);
                    }
                } else {
                    this.copySnapshot(cube, snapshotResPath);
                }
                logger.info("add cube-level snapshot table {} for cube {} to migration list", (Object)snapshotResPath, (Object)cube);
            }
        }
        return futureList;
    }

    private ProjectInstance getDstProject(ProjectInstance srcProject) throws IOException {
        ProjectInstance dstProject = this.dstProjects.get(srcProject.getName());
        if (dstProject == null) {
            dstProject = this.dstCluster.getProject(srcProject.getName());
        }
        if (dstProject == null) {
            dstProject = ProjectInstance.create(srcProject.getName(), srcProject.getOwner(), srcProject.getDescription(), srcProject.getOverrideKylinProps(), null, null);
            dstProject.setUuid(srcProject.getUuid());
        }
        return dstProject;
    }

    private void putUserInfo(String userName) throws IOException {
        String userKey = KylinUserService.getId(userName);
        ManagedUser user = this.srcCluster.getUserDetails(userKey);
        if (user == null) {
            logger.warn("Cannot find user {}", (Object)userName);
            return;
        }
        this.dstCluster.saveUserInfo(userKey, user);
    }

    private void copyMetaResource(String item) throws IOException {
        RawResource res = this.srcCluster.getResource(item);
        this.dstCluster.putResource(item, res);
        res.content().close();
    }

    private void copyDictionary(CubeInstance cube, String dictPath) throws IOException {
        if (this.dstCluster.exists(dictPath)) {
            logger.info("Item {} has already existed in destination cluster", (Object)dictPath);
            return;
        }
        DictionaryInfo dictInfo = this.srcCluster.getDictionaryInfo(dictPath);
        String dupDict = this.dstCluster.saveDictionary(dictInfo);
        if (dupDict != null) {
            for (CubeSegment segment : cube.getSegments()) {
                for (Map.Entry<String, String> entry : segment.getDictionaries().entrySet()) {
                    if (!entry.getValue().equalsIgnoreCase(dictPath)) continue;
                    entry.setValue(dupDict);
                }
            }
            logger.info("Item {} is dup, instead {} is reused", (Object)dictPath, (Object)dupDict);
        }
    }

    private void copySnapshot(CubeInstance cube, String snapshotTablePath) throws IOException {
        if (this.dstCluster.exists(snapshotTablePath)) {
            logger.info("Item {} has already existed in destination cluster", (Object)snapshotTablePath);
            return;
        }
        SnapshotTable snapshotTable = this.srcCluster.getSnapshotTable(snapshotTablePath);
        this.dstCluster.saveSnapshotTable(snapshotTable);
    }

    private void copyHDFSJobInfo(String jobId) throws Exception {
        String srcDirQualified = this.srcCluster.getJobWorkingDirQualified(jobId);
        String dstDirQualified = this.dstCluster.getJobWorkingDirQualified(jobId);
        if (this.ifExecute) {
            this.dstCluster.copyInitOnJobCluster(new Path(dstDirQualified));
            this.copyHDFSPath(srcDirQualified, this.srcCluster.jobConf, dstDirQualified, this.dstCluster.jobConf);
        } else {
            logger.info("copied hdfs directory from {} to {}", (Object)srcDirQualified, (Object)dstDirQualified);
        }
    }

    private void copyHTable(CubeSegment segment) throws IOException {
        String tableName = segment.getStorageLocationIdentifier();
        if (this.ifExecute) {
            if (this.checkHTableExist(segment)) {
                logger.info("htable {} has already existed in dst, will skip the migration", (Object)tableName);
            } else {
                this.copyHTable(tableName, true);
                if (!this.checkHTableEquals(tableName)) {
                    logger.error("htable {} is copied to dst with different size!!!", (Object)tableName);
                }
            }
        }
        logger.info("migrated htable {} for segment {}", (Object)tableName, (Object)segment);
    }

    private boolean checkHTableExist(CubeSegment segment) throws IOException {
        String tableName = segment.getStorageLocationIdentifier();
        TableName htableName = TableName.valueOf((String)tableName);
        if (!this.dstCluster.checkExist(htableName, segment)) {
            return false;
        }
        if (!this.checkHTableEquals(tableName)) {
            logger.warn("although htable {} exists in destination, the details data are different", (Object)tableName);
            this.dstCluster.deleteHTable(tableName);
            return false;
        }
        return true;
    }

    private boolean checkHTableEquals(String tableName) throws IOException {
        HBaseResponse respSrc = HBaseInfoUtil.getHBaseInfo(tableName, this.srcCluster.hbaseConn);
        HBaseResponse respDst = HBaseInfoUtil.getHBaseInfo(tableName, this.dstCluster.hbaseConn);
        return HBaseInfoUtil.checkEquals(respSrc, respDst);
    }

    private void copyHTable(ExtTableSnapshotInfo extTableSnapshotInfo) throws IOException {
        String tableName = extTableSnapshotInfo.getStorageLocationIdentifier();
        if (this.ifExecute) {
            TableName htableName = TableName.valueOf((String)tableName);
            if (this.dstCluster.htableExists(htableName)) {
                logger.warn("htable {} already exists in the dst cluster and will skip the htable migration");
            } else {
                this.copyHTable(tableName, false);
            }
        }
        logger.info("migrated htable {} for ext table snapshot {}", (Object)tableName, (Object)extTableSnapshotInfo.getTableName());
    }

    private void copyHTable(String tableName, boolean ifDeployCoprocessor) {
        if (this.ifExecute) {
            TableName htableName = TableName.valueOf((String)tableName);
            try {
                this.copyHFileByDistCp(tableName);
                Table table = this.srcCluster.hbaseConn.getTable(TableName.valueOf((String)tableName));
                byte[][] endKeys = this.srcCluster.hbaseConn.getRegionLocator(htableName).getEndKeys();
                byte[][] splitKeys = (byte[][])Arrays.copyOfRange(endKeys, 0, endKeys.length - 1);
                HTableDescriptor tableDesc = new HTableDescriptor(table.getTableDescriptor());
                this.dstCluster.resetTableHost(tableDesc);
                if (ifDeployCoprocessor) {
                    this.dstCluster.deployCoprocessor(tableDesc, this.coprocessorJarPath);
                }
                this.dstCluster.createTable(tableDesc, splitKeys);
                this.dstCluster.bulkLoadTable(tableName);
            }
            catch (Exception e) {
                logger.error("fail to migrate htable {} due to {} ", (Object)tableName, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    protected void copyHFileByDistCp(String tableName) throws Exception {
        String srcDirQualified = this.srcCluster.getRootDirQualifiedOfHTable(tableName);
        String dstDirQualified = this.dstCluster.getRootDirQualifiedOfHTable(tableName);
        this.dstCluster.copyInitOnHBaseCluster(new Path(dstDirQualified));
        this.copyHDFSPath(srcDirQualified, this.srcCluster.hbaseConf, dstDirQualified, this.dstCluster.hbaseConf);
    }

    protected void copyHDFSPath(String srcDir, Configuration srcConf, String dstDir, Configuration dstConf) throws Exception {
        logger.info("start to copy hdfs directory from {} to {}", (Object)srcDir, (Object)dstDir);
        DistCpOptions.Builder builder = new DistCpOptions.Builder(new Path(srcDir), new Path(dstDir));
        DistCpOptions distCpOptions = builder.preserve(DistCpOptions.FileAttribute.BLOCKSIZE).withBlocking(true).build();
        this.setTargetPathExists(distCpOptions);
        DistCp distCp = new DistCp(this.getConfOfDistCp(), distCpOptions);
        distCp.execute();
        logger.info("copied hdfs directory from {} to {}", (Object)srcDir, (Object)dstDir);
    }

    protected Configuration getConfOfDistCp() {
        return this.distCpConf;
    }

    public void setTargetPathExists(DistCpOptions inputOptions) throws IOException {
        Path target = inputOptions.getTargetPath();
        FileSystem targetFS = target.getFileSystem(this.dstCluster.jobConf);
        boolean targetExists = targetFS.exists(target);
        this.dstCluster.jobConf.setBoolean("distcp.target.path.exists", targetExists);
    }

    private void addHybrid(HybridInstance hybrid) {
        this.hybrids.add(hybrid);
        for (IRealization realization : hybrid.getRealizations()) {
            this.addRealization(realization);
        }
    }

    private void addRealization(IRealization realization) {
        if (realization instanceof HybridInstance) {
            this.addHybrid((HybridInstance)realization);
        } else if (realization instanceof CubeInstance) {
            this.cubes.add((CubeInstance)realization);
        } else {
            logger.warn("Realization {} is neither hybrid nor cube", (Object)realization);
        }
    }

    public static void main(String[] args) {
        CubeMigrationCrossClusterCLI cli = new CubeMigrationCrossClusterCLI();
        cli.execute(args);
    }

    static {
        OptionBuilder.withArgName((String)"kylinUriSrc");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the source kylin uri with format user:pwd@host:port");
        OPTION_KYLIN_URI_SRC = OptionBuilder.create((String)"kylinUriSrc");
        OptionBuilder.withArgName((String)"kylinUriDst");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the destination kylin uri with format user:pwd@host:port");
        OPTION_KYLIN_URI_DST = OptionBuilder.create((String)"kylinUriDst");
        OptionBuilder.withArgName((String)"updateMappingPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the path for the update mapping file");
        OPTION_UPDATE_MAPPING = OptionBuilder.create((String)"updateMappingPath");
        OptionBuilder.withArgName((String)"cube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify which cube to extract");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
        OptionBuilder.withArgName((String)"hybrid");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify which hybrid to extract");
        OPTION_HYBRID = OptionBuilder.create((String)"hybrid");
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify realizations in which project to extract");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"all");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify realizations in all projects to extract");
        OPTION_All = OptionBuilder.create((String)"all");
        OptionBuilder.withArgName((String)"dstHiveCheck");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to check destination hive tables");
        OPTION_DST_HIVE_CHECK = OptionBuilder.create((String)"dstHiveCheck");
        OptionBuilder.withArgName((String)"overwrite");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to overwrite existing cubes");
        OPTION_OVERWRITE = OptionBuilder.create((String)"overwrite");
        OptionBuilder.withArgName((String)"schemaOnly");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether only migrate cube related schema");
        OPTION_SCHEMA_ONLY = OptionBuilder.create((String)"schemaOnly");
        OptionBuilder.withArgName((String)"execute");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether it's to execute the migration");
        OPTION_EXECUTE = OptionBuilder.create((String)"execute");
        OptionBuilder.withArgName((String)"coprocessorPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the path of coprocessor to be deployed");
        OPTION_COPROCESSOR_PATH = OptionBuilder.create((String)"coprocessorPath");
        OptionBuilder.withArgName((String)"codeOfFSHAEnabled");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to enable the namenode ha of clusters");
        OPTION_FS_HA_ENABLED_CODE = OptionBuilder.create((String)"codeOfFSHAEnabled");
        OptionBuilder.withArgName((String)"distCpJobQueue");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the mapreduce.job.queuename for DistCp job ");
        OPTION_DISTCP_JOB_QUEUE = OptionBuilder.create((String)"distCpJobQueue");
        OptionBuilder.withArgName((String)"distCpJobMemory");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the mapreduce.map.memory.mb for DistCp job ");
        OPTION_DISTCP_JOB_MEMORY = OptionBuilder.create((String)"distCpJobMemory");
        OptionBuilder.withArgName((String)"nThread");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the number of threads for migrating cube data in parallel ");
        OPTION_THREAD_NUM = OptionBuilder.create((String)"nThread");
    }

    private static abstract class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        public abstract void doRun() throws Exception;
    }
}

