/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.migration;

import java.io.IOException;
import java.util.List;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfoManager;
import org.apache.kylin.dict.lookup.SnapshotManager;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationRegistry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.apache.kylin.tool.migration.ClusterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrcClusterUtil
extends ClusterUtil {
    private static final Logger logger = LoggerFactory.getLogger(SrcClusterUtil.class);
    private static final String hbaseRootDirConfKey = "hbase.rootdir";
    private final String hbaseDataDir;
    private final TableMetadataManager metadataManager;
    private final DataModelManager modelManager;
    private final ProjectManager projectManager;
    private final HybridManager hybridManager;
    private final CubeManager cubeManager;
    private final CubeDescManager cubeDescManager;
    private final RealizationRegistry realizationRegistry;
    private final DictionaryManager dictionaryManager;
    private final SnapshotManager snapshotManager;
    private final ExtTableSnapshotInfoManager extSnapshotInfoManager;

    public SrcClusterUtil(String configURI, boolean ifJobFSHAEnabled, boolean ifHBaseFSHAEnabled) throws IOException {
        super(configURI, ifJobFSHAEnabled, ifHBaseFSHAEnabled);
        this.hbaseDataDir = this.hbaseConf.get(hbaseRootDirConfKey) + "/data/default/";
        this.metadataManager = TableMetadataManager.getInstance(this.kylinConfig);
        this.modelManager = DataModelManager.getInstance(this.kylinConfig);
        this.projectManager = ProjectManager.getInstance(this.kylinConfig);
        this.hybridManager = HybridManager.getInstance(this.kylinConfig);
        this.cubeManager = CubeManager.getInstance(this.kylinConfig);
        this.cubeDescManager = CubeDescManager.getInstance(this.kylinConfig);
        this.realizationRegistry = RealizationRegistry.getInstance(this.kylinConfig);
        this.dictionaryManager = DictionaryManager.getInstance(this.kylinConfig);
        this.snapshotManager = SnapshotManager.getInstance(this.kylinConfig);
        this.extSnapshotInfoManager = ExtTableSnapshotInfoManager.getInstance(this.kylinConfig);
    }

    public String getDefaultCoprocessorJarPath() {
        return this.kylinConfig.getCoprocessorLocalJar();
    }

    @Override
    public ProjectInstance getProject(String projectName) throws IOException {
        return this.projectManager.getProject(projectName);
    }

    public List<ProjectInstance> listAllProjects() throws IOException {
        return this.projectManager.listAllProjects();
    }

    public ProjectInstance getProjectByRealization(RealizationType type, String realizationName) throws IOException {
        List<ProjectInstance> ret = this.projectManager.findProjects(type, realizationName);
        return ret.isEmpty() ? null : ret.get(0);
    }

    public CubeInstance getCube(String name) throws IOException {
        return this.cubeManager.getCube(name);
    }

    public CubeDesc getCubeDesc(String name) throws IOException {
        return this.cubeDescManager.getCubeDesc(name);
    }

    public HybridInstance getHybrid(String name) throws IOException {
        return this.hybridManager.getHybridInstance(name);
    }

    public IRealization getRealization(RealizationEntry entry) throws IOException {
        return this.realizationRegistry.getRealization(entry.getType(), entry.getRealization());
    }

    public DataModelDesc getDataModelDesc(String modelName) throws IOException {
        return this.modelManager.getDataModelDesc(modelName);
    }

    public TableDesc getTableDesc(String tableIdentity, String projectName) throws IOException {
        TableDesc ret = this.metadataManager.getStore().getResource(TableDesc.concatResourcePath(tableIdentity, projectName), TableMetadataManager.TABLE_SERIALIZER);
        if (projectName != null && ret == null) {
            ret = this.metadataManager.getStore().getResource(TableDesc.concatResourcePath(tableIdentity, null), TableMetadataManager.TABLE_SERIALIZER);
        }
        return ret;
    }

    @Override
    public DictionaryInfo getDictionaryInfo(String dictPath) throws IOException {
        return this.dictionaryManager.getDictionaryInfo(dictPath);
    }

    @Override
    public SnapshotTable getSnapshotTable(String snapshotPath) throws IOException {
        return this.snapshotManager.getSnapshotTable(snapshotPath);
    }

    public ExtTableSnapshotInfo getExtTableSnapshotInfo(String snapshotPath) throws IOException {
        return this.extSnapshotInfoManager.getSnapshot(snapshotPath);
    }

    @Override
    public String getRootDirQualifiedOfHTable(String tableName) {
        return this.hbaseDataDir + tableName;
    }
}

