/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.kv;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class RowKeyEncoderProvider
implements Serializable {
    private CubeSegment cubeSegment;
    private HashMap<Long, RowKeyEncoder> rowKeyEncoders;

    public RowKeyEncoderProvider(CubeSegment cubeSegment) {
        this.cubeSegment = cubeSegment;
        this.rowKeyEncoders = Maps.newHashMap();
    }

    public RowKeyEncoder getRowkeyEncoder(Cuboid cuboid) {
        RowKeyEncoder rowKeyEncoder = this.rowKeyEncoders.get(cuboid.getId());
        if (rowKeyEncoder == null) {
            rowKeyEncoder = new RowKeyEncoder(this.cubeSegment, cuboid);
            this.rowKeyEncoders.put(cuboid.getId(), rowKeyEncoder);
        }
        return rowKeyEncoder;
    }
}

