/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.upgrade.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CubeMetadataUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(CubeMetadataUpgrade.class);
    protected KylinConfig config = null;
    protected ResourceStore store;
    protected List<String> updatedResources = Lists.newArrayList();
    protected List<String> errorMsgs = Lists.newArrayList();

    public CubeMetadataUpgrade(String newMetadataUrl) {
        KylinConfig.destroyInstance();
        this.config = KylinConfig.createInstanceFromUri(newMetadataUrl);
        this.store = ResourceStore.getStore(this.config);
    }

    protected List<String> listResourceStore(String pathRoot) {
        List<String> paths = null;
        try {
            paths = this.store.collectResourceRecursively(pathRoot, ".json");
        }
        catch (IOException e1) {
            logger.error("error", (Throwable)e1);
            this.errorMsgs.add("Get IOException when scan resource store at: /cube_desc");
        }
        return paths;
    }

    public void clear() {
        this.config.clearManagers();
    }

    public void verify() {
        logger.info("=================================================================");
        logger.info("The changes are applied, now it's time to verify the new metadata store by reloading all metadata:");
        logger.info("=================================================================");
        this.config.clearManagers();
        DataModelManager.getInstance(this.config);
        CubeDescManager.getInstance(this.config);
        CubeManager.getInstance(this.config);
        ProjectManager.getInstance(this.config);
    }

    public abstract void upgradeNonCompatibleMeta();

    public abstract void upgradeCompatibleMeta();

    public static void upgradeOrVerify(Class upgradeClass, String[] args, boolean firstStepInChain, boolean lastStepInChain) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String newMetadataUrl;
        if (args == null || args.length != 1) {
            System.out.println("Usage: java CubeMetadataUpgrade <metadata_export_folder>");
            System.out.println(", where metadata_export_folder is the folder containing your current metadata's dump (Upgrade program will not modify it directly, relax.");
            return;
        }
        String currentMetaDumpFolderPath = args[0];
        File currentMetaDumpFolder = new File(currentMetaDumpFolderPath);
        if (!currentMetaDumpFolder.exists()) {
            System.out.println("Provided folder doesn't exist: '" + currentMetaDumpFolderPath + "'");
            return;
        }
        if (!currentMetaDumpFolder.isDirectory()) {
            System.out.println("Provided folder is not a directory: '" + currentMetaDumpFolderPath + "'");
            return;
        }
        if (firstStepInChain) {
            newMetadataUrl = currentMetaDumpFolder.getAbsolutePath() + "_workspace";
            try {
                FileUtils.deleteDirectory((File)new File(newMetadataUrl));
                FileUtils.copyDirectory((File)currentMetaDumpFolder, (File)new File(newMetadataUrl));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            newMetadataUrl = currentMetaDumpFolder.getAbsolutePath();
        }
        CubeMetadataUpgrade instance = (CubeMetadataUpgrade)upgradeClass.getConstructor(String.class).newInstance(newMetadataUrl);
        instance.upgradeNonCompatibleMeta();
        logger.info("=================================================================");
        logger.info("Run {} completed", (Object)upgradeClass.toString());
        logger.info("=================================================================");
        if (instance.errorMsgs.size() > 0) {
            logger.info("Here are the error/warning messages, you may need check:");
            for (String s : instance.errorMsgs) {
                logger.error(s);
            }
        } else {
            logger.info("No error or warning messages; The migration is success.");
        }
        if (lastStepInChain) {
            instance.upgradeCompatibleMeta();
            instance.verify();
        }
    }
}

