/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.IDictionaryValueEnumerator;
import org.apache.kylin.metadata.datatype.DataType;

public class MultipleDictionaryValueEnumerator
implements IDictionaryValueEnumerator {
    private List<Integer> curKeys = Lists.newArrayList();
    private String curValue = null;
    private List<Dictionary<String>> dictionaryList;
    private DataType dataType;

    public MultipleDictionaryValueEnumerator(DataType dataType, List<Dictionary<String>> dictionaryInfoList) {
        this.dataType = dataType;
        this.dictionaryList = Lists.newArrayListWithCapacity((int)dictionaryInfoList.size());
        for (Dictionary<String> dict : dictionaryInfoList) {
            this.dictionaryList.add(dict);
            this.curKeys.add(dict.getMinId());
        }
    }

    @Override
    public String current() throws IOException {
        return this.curValue;
    }

    @Override
    public boolean moveNext() throws IOException {
        String minValue = null;
        int curDictIndex = 0;
        for (int i = 0; i < this.dictionaryList.size(); ++i) {
            int curKey;
            Dictionary<String> dict = this.dictionaryList.get(i);
            if (dict == null || (curKey = this.curKeys.get(i).intValue()) > dict.getMaxId()) continue;
            String curValue = dict.getValueFromId(curKey);
            if (minValue != null && this.dataType.compare(minValue, curValue) <= 0) continue;
            minValue = curValue;
            curDictIndex = i;
        }
        if (minValue == null) {
            this.curValue = null;
            return false;
        }
        this.curValue = minValue;
        this.curKeys.set(curDictIndex, this.curKeys.get(curDictIndex) + 1);
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

