/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTAggregateScanner;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GTScanRequestBuilder;
import org.apache.kylin.gridtable.GTTwoLayerAggregateParam;
import org.apache.kylin.gridtable.IGTCodeSystem;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureTransformation;

public class GTAggregateTransformScanner
implements IGTScanner {
    protected final IGTScanner inputScanner;
    private final GTScanRequest req;
    private final GTTwoLayerAggregateParam twoLayerAggParam;
    private long inputRowCount = 0L;
    private Iterator<GTRecord> iterator = null;

    public GTAggregateTransformScanner(IGTScanner inputScanner, GTScanRequest req) {
        this.inputScanner = inputScanner;
        this.req = req;
        this.twoLayerAggParam = req.getAggregateTransformParam();
    }

    @Override
    public GTInfo getInfo() {
        return this.inputScanner.getInfo();
    }

    @Override
    public void close() throws IOException {
        this.inputScanner.close();
    }

    @Override
    public Iterator<GTRecord> iterator() {
        if (this.iterator == null) {
            this.iterator = this.twoLayerAggParam.satisfyPrefix(this.req.getDimensions()) ? new FragmentTransformGTRecordIterator(this.inputScanner.iterator()) : new NormalTransformGTRecordIterator(this.inputScanner.iterator());
        }
        return this.iterator;
    }

    public long getInputRowCount() {
        return this.inputRowCount;
    }

    private class PrefixFragmentIterator
    implements Iterator<Iterator<GTRecord>> {
        private final PeekingIterator<GTRecord> input;
        private final Comparator<GTRecord> prefixComparator;
        private GTRecord current;

        PrefixFragmentIterator(Iterator<GTRecord> input, ImmutableBitSet prefixMask) {
            this.input = Iterators.peekingIterator(input);
            this.prefixComparator = GTRecord.getComparator(prefixMask);
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        @Override
        public Iterator<GTRecord> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = null;
            return new Iterator<GTRecord>(){

                @Override
                public boolean hasNext() {
                    return PrefixFragmentIterator.this.current == null || PrefixFragmentIterator.this.shouldIncludeNext(PrefixFragmentIterator.this.current);
                }

                @Override
                public GTRecord next() {
                    if (PrefixFragmentIterator.this.current == null) {
                        PrefixFragmentIterator.this.current = new GTRecord(GTAggregateTransformScanner.this.req.getInfo());
                    }
                    GTAggregateTransformScanner.this.inputRowCount++;
                    PrefixFragmentIterator.this.current.shallowCopyFrom((GTRecord)PrefixFragmentIterator.this.input.next());
                    return PrefixFragmentIterator.this.current;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private boolean isSamePrefix(GTRecord o1, GTRecord o2) {
            return this.prefixComparator.compare(o1, o2) == 0;
        }

        private boolean shouldIncludeNext(GTRecord current) {
            return this.input.hasNext() && this.isSamePrefix(current, (GTRecord)this.input.peek());
        }
    }

    private abstract class TransformGTRecordIterator
    implements Iterator<GTRecord> {
        private final IGTCodeSystem codeSystem;
        private final ImmutableBitSet tMetrics;
        private final String[] tMetricsFuncs;
        private final int[] sMetrics;
        protected final GTScanRequest innerReq;

        TransformGTRecordIterator() {
            this.codeSystem = GTAggregateTransformScanner.this.req.getInfo().getCodeSystem();
            this.tMetrics = ((GTAggregateTransformScanner)GTAggregateTransformScanner.this).twoLayerAggParam.outsideLayerMetrics;
            this.tMetricsFuncs = ((GTAggregateTransformScanner)GTAggregateTransformScanner.this).twoLayerAggParam.outsideLayerMetricsFuncs;
            this.sMetrics = ((GTAggregateTransformScanner)GTAggregateTransformScanner.this).twoLayerAggParam.insideLayerMetrics;
            this.innerReq = this.transformGTScanRequest(GTAggregateTransformScanner.this.req);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private GTScanRequest transformGTScanRequest(GTScanRequest req) {
            int c;
            int i;
            ImmutableBitSet aggrGroupBy = req.getAggrGroupBy();
            aggrGroupBy = aggrGroupBy.or(((GTAggregateTransformScanner)GTAggregateTransformScanner.this).twoLayerAggParam.vanishDimMask);
            ImmutableBitSet metrics = req.getAggrMetrics();
            String[] metricsFuncs = req.getAggrMetricsFuncs();
            HashMap metricsFuncsMap = Maps.newHashMap();
            for (int i2 = 0; i2 < metrics.trueBitCount(); ++i2) {
                int c2 = metrics.trueBitAt(i2);
                metricsFuncsMap.put(c2, metricsFuncs[i2]);
            }
            String[] sMetricsFuncs = ((GTAggregateTransformScanner)GTAggregateTransformScanner.this).twoLayerAggParam.insideLayerMetricsFuncs;
            for (i = 0; i < this.sMetrics.length; ++i) {
                c = this.sMetrics[i];
                metricsFuncsMap.put(c, sMetricsFuncs[i]);
            }
            metrics = metrics.or(ImmutableBitSet.valueOf(this.sMetrics)).andNot(this.tMetrics);
            metricsFuncs = new String[metrics.trueBitCount()];
            for (i = 0; i < metrics.trueBitCount(); ++i) {
                c = metrics.trueBitAt(i);
                metricsFuncs[i] = (String)metricsFuncsMap.get(c);
            }
            return new GTScanRequestBuilder().setAggrMetrics(metrics).setAggrMetricsFuncs(metricsFuncs).setInfo(req.getInfo()).setDimensions(req.getDimensions()).setAggrGroupBy(aggrGroupBy).setAggCacheMemThreshold(req.getAggCacheMemThreshold()).setStoragePushDownLimit(req.getStoragePushDownLimit()).setHavingFilterPushDown(req.getHavingFilterPushDown()).createGTScanRequest();
        }

        protected GTRecord transformGTRecord(GTRecord record) {
            MeasureAggregator<?>[] tAggrs = this.codeSystem.newMetricsAggregators(this.tMetrics, this.tMetricsFuncs);
            for (int i = 0; i < this.tMetrics.trueBitCount(); ++i) {
                int o = this.sMetrics[i];
                Object oMetric = this.codeSystem.decodeColumnValue(o, record.cols[o].asBuffer());
                Object cMetric = ((MeasureTransformation)((Object)tAggrs[i])).transformMeasure(oMetric);
                int c = this.tMetrics.trueBitAt(i);
                record.setValue(c, cMetric);
            }
            return record;
        }
    }

    private class NormalTransformGTRecordIterator
    extends TransformGTRecordIterator {
        private final Iterator<GTRecord> aggRecordIterator;
        private final GTAggregateScanner aggregateScanner;

        NormalTransformGTRecordIterator(final Iterator<GTRecord> input) {
            IGTScanner gtScanner = new IGTScanner(){

                @Override
                public GTInfo getInfo() {
                    return GTAggregateTransformScanner.this.req.getInfo();
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public Iterator<GTRecord> iterator() {
                    return input;
                }
            };
            this.aggregateScanner = new GTAggregateScanner(gtScanner, this.innerReq);
            this.aggRecordIterator = this.aggregateScanner.iterator();
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.aggRecordIterator.hasNext();
            if (!hasNext) {
                try {
                    this.aggregateScanner.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return hasNext;
        }

        @Override
        public GTRecord next() {
            return this.transformGTRecord(this.aggRecordIterator.next());
        }
    }

    private class FragmentTransformGTRecordIterator
    extends TransformGTRecordIterator {
        private final PrefixFragmentIterator fragmentIterator;
        private GTAggregateScanner aggregateScanner;
        private Iterator<GTRecord> transformedFragment = null;

        FragmentTransformGTRecordIterator(Iterator<GTRecord> input) {
            this.fragmentIterator = new PrefixFragmentIterator(input, ((GTAggregateTransformScanner)GTAggregateTransformScanner.this).twoLayerAggParam.vanishDimMask);
        }

        @Override
        public boolean hasNext() {
            if (this.transformedFragment != null && this.transformedFragment.hasNext()) {
                return true;
            }
            if (!this.fragmentIterator.hasNext()) {
                try {
                    this.aggregateScanner.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            IGTScanner fragmentScanner = new IGTScanner(){

                @Override
                public GTInfo getInfo() {
                    return GTAggregateTransformScanner.this.req.getInfo();
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public Iterator<GTRecord> iterator() {
                    return FragmentTransformGTRecordIterator.this.fragmentIterator.next();
                }
            };
            this.aggregateScanner = new GTAggregateScanner(fragmentScanner, this.innerReq);
            this.transformedFragment = this.aggregateScanner.iterator();
            return this.hasNext();
        }

        @Override
        public GTRecord next() {
            return this.transformGTRecord(this.transformedFragment.next());
        }
    }
}

