/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter.function;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.metadata.filter.BuiltInFunctionTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.UDF.MassInTupleFilter;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class Functions {
    private static Map<String, Class> SUPPORTED_UDF = Maps.newHashMap();

    public static TupleFilter getFunctionTupleFilter(String name) {
        if (name == null) {
            throw new IllegalStateException("Function name cannot be null");
        }
        if (SUPPORTED_UDF.containsKey(name = name.toUpperCase(Locale.ROOT))) {
            try {
                return (TupleFilter)SUPPORTED_UDF.get(name).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Failed to on constructing FunctionTupleFilter for " + name);
            }
        }
        return new BuiltInFunctionTupleFilter(name);
    }

    static {
        SUPPORTED_UDF.put("MASSIN", MassInTupleFilter.class);
    }

    public static enum FilterTableType {
        HDFS,
        HBASE_TABLE;

    }
}

