/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.security.User;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.util.DeployCoprocessorCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeHTableUtil {
    private static final Logger logger = LoggerFactory.getLogger(CubeHTableUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createHTable(CubeSegment cubeSegment, byte[][] splitKeys, boolean continueOnExists) throws IOException {
        String commitInfo;
        TableName tableName = TableName.valueOf((String)cubeSegment.getStorageLocationIdentifier());
        CubeInstance cubeInstance = cubeSegment.getCubeInstance();
        CubeDesc cubeDesc = cubeInstance.getDescriptor();
        KylinConfig kylinConfig = cubeDesc.getConfig();
        TableDescriptorBuilder descBuilder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)cubeSegment.getStorageLocationIdentifier()));
        descBuilder.setValue("SPLIT_POLICY", DisabledRegionSplitPolicy.class.getName());
        descBuilder.setValue("KYLIN_HOST", kylinConfig.getMetadataUrlPrefix());
        descBuilder.setValue("CREATION_TIME", String.valueOf(System.currentTimeMillis()));
        if (!StringUtils.isEmpty((String)kylinConfig.getKylinOwner())) {
            descBuilder.setValue("OWNER", kylinConfig.getKylinOwner());
        }
        if (!StringUtils.isEmpty((String)(commitInfo = KylinVersion.getGitCommitInfo()))) {
            descBuilder.setValue("GIT_COMMIT", commitInfo);
        }
        descBuilder.setValue("USER", cubeInstance.getOwner());
        descBuilder.setValue("SEGMENT", cubeSegment.toString());
        Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
        Connection conn = HBaseConnection.get(kylinConfig.getStorageUrl());
        Admin admin = conn.getAdmin();
        try {
            if (User.isHBaseSecurityEnabled((Configuration)conf)) {
                descBuilder.addCoprocessor("org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint");
            }
            for (HBaseColumnFamilyDesc cfDesc : cubeDesc.getHbaseMapping().getColumnFamily()) {
                ColumnFamilyDescriptor cf = CubeHTableUtil.createColumnFamily(kylinConfig, cfDesc.getName(), cfDesc.isMemoryHungry());
                descBuilder.setColumnFamily(cf);
            }
            if (admin.tableExists(tableName)) {
                if (!continueOnExists) {
                    throw new RuntimeException("HBase table " + tableName.toString() + " exists!");
                }
                logger.warn("HBase table " + tableName + " exists when create HTable, continue the process!");
                if (admin.isTableEnabled(tableName)) {
                    try {
                        admin.disableTable(tableName);
                        logger.warn("Disabled existing enabled HBase table " + tableName.toString());
                    }
                    catch (TableNotEnabledException e) {
                        logger.warn("HBase table " + tableName + " already disabled.", (Throwable)e);
                    }
                } else {
                    logger.warn("HBase table exists but in disabled state.");
                }
                try {
                    admin.deleteTable(tableName);
                    logger.info("Deleted existing HBase table " + tableName.toString());
                }
                catch (TableNotFoundException e) {
                    logger.warn("HBase table " + tableName + " already deleted.", (Throwable)e);
                }
            }
            DeployCoprocessorCLI.deployCoprocessor(descBuilder);
            admin.createTable(descBuilder.build(), splitKeys);
            Preconditions.checkArgument(admin.isTableAvailable(tableName), "table " + tableName + " created, but is not available due to some reasons");
            logger.info("create hbase table " + tableName + " done.");
        }
        finally {
            IOUtils.closeQuietly((Closeable)admin);
        }
    }

    public static void deleteHTable(TableName tableName) throws IOException {
        Admin admin = HBaseConnection.get(KylinConfig.getInstanceFromEnv().getStorageUrl()).getAdmin();
        try {
            if (admin.tableExists(tableName)) {
                logger.info("disabling hbase table " + tableName);
                admin.disableTable(tableName);
                logger.info("deleting hbase table " + tableName);
                admin.deleteTable(tableName);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)admin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createBenchmarkHTable(TableName tableName, String cfName) throws IOException {
        Admin admin = HBaseConnection.get(KylinConfig.getInstanceFromEnv().getStorageUrl()).getAdmin();
        try {
            if (admin.tableExists(tableName)) {
                logger.info("disabling hbase table " + tableName);
                admin.disableTable(tableName);
                logger.info("deleting hbase table " + tableName);
                admin.deleteTable(tableName);
            }
            TableDescriptorBuilder descBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
            descBuilder.setValue("SPLIT_POLICY", DisabledRegionSplitPolicy.class.getName());
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            descBuilder.modifyColumnFamily(CubeHTableUtil.createColumnFamily(kylinConfig, cfName, false));
            logger.info("creating hbase table " + tableName);
            admin.createTable(descBuilder.build(), (byte[][])null);
            Preconditions.checkArgument(admin.isTableAvailable(tableName), "table " + tableName + " created, but is not available due to some reasons");
            logger.info("create hbase table " + tableName + " done.");
        }
        finally {
            IOUtils.closeQuietly((Closeable)admin);
        }
    }

    public static ColumnFamilyDescriptor createColumnFamily(KylinConfig kylinConfig, String cfName, boolean isMemoryHungry) {
        String hbaseDefaultCC;
        ColumnFamilyDescriptorBuilder cf = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes(cfName));
        cf.setMaxVersions(1);
        if (isMemoryHungry) {
            cf.setBlocksize(kylinConfig.getHbaseDefaultBlockSize());
        } else {
            cf.setBlocksize(kylinConfig.getHbaseSmallFamilyBlockSize());
        }
        switch (hbaseDefaultCC = kylinConfig.getHbaseDefaultCompressionCodec().toLowerCase(Locale.ROOT)) {
            case "snappy": {
                logger.info("hbase will use snappy to compress data");
                cf.setCompressionType(Compression.Algorithm.SNAPPY);
                break;
            }
            case "lzo": {
                logger.info("hbase will use lzo to compress data");
                cf.setCompressionType(Compression.Algorithm.LZO);
                break;
            }
            case "gz": 
            case "gzip": {
                logger.info("hbase will use gzip to compress data");
                cf.setCompressionType(Compression.Algorithm.GZ);
                break;
            }
            case "lz4": {
                logger.info("hbase will use lz4 to compress data");
                cf.setCompressionType(Compression.Algorithm.LZ4);
                break;
            }
            default: {
                logger.info("hbase will not use any compression algorithm to compress data");
                cf.setCompressionType(Compression.Algorithm.NONE);
            }
        }
        try {
            String encodingStr = kylinConfig.getHbaseDefaultEncoding();
            DataBlockEncoding encoding = DataBlockEncoding.valueOf((String)encodingStr);
            cf.setDataBlockEncoding(encoding);
        }
        catch (Exception e) {
            logger.info("hbase will not use any encoding", (Throwable)e);
            cf.setDataBlockEncoding(DataBlockEncoding.NONE);
        }
        cf.setInMemory(false);
        cf.setBloomFilterType(BloomType.NONE);
        cf.setScope(kylinConfig.getHBaseReplicationScope());
        return cf.build();
    }
}

