/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.protobuf.generated.HFileProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.flink.FlinkBatchCubingJobBuilder2;
import org.apache.kylin.engine.flink.FlinkExecutable;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.storage.hbase.steps.FlinkCubeHFile;
import org.apache.kylin.storage.hbase.steps.HBaseJobSteps;

public class HBaseFlinkSteps
extends HBaseJobSteps {
    public HBaseFlinkSteps(CubeSegment seg) {
        super(seg);
    }

    @Override
    public AbstractExecutable createConvertCuboidToHfileStep(String jobId) {
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        String inputPath = cuboidRootPath + (cuboidRootPath.endsWith("/") ? "" : "/");
        FlinkBatchCubingJobBuilder2 jobBuilder2 = new FlinkBatchCubingJobBuilder2(this.seg, null, Integer.valueOf(0));
        FlinkExecutable flinkExecutable = new FlinkExecutable();
        flinkExecutable.setClassName(FlinkCubeHFile.class.getName());
        flinkExecutable.setParam(FlinkCubeHFile.OPTION_CUBE_NAME.getOpt(), this.seg.getRealization().getName());
        flinkExecutable.setParam(FlinkCubeHFile.OPTION_SEGMENT_ID.getOpt(), this.seg.getUuid());
        flinkExecutable.setParam(FlinkCubeHFile.OPTION_META_URL.getOpt(), jobBuilder2.getSegmentMetadataUrl(this.seg.getConfig(), jobId));
        flinkExecutable.setParam(FlinkCubeHFile.OPTION_INPUT_PATH.getOpt(), inputPath);
        String rootPath = this.getRealizationRootPath(jobId);
        String outputPath = this.getHFilePath(jobId);
        String partitionOutputPath = this.getRowkeyDistributionOutputPath(jobId) + "/part-r-00000_hfile";
        if (this.seg.getConfig().isHFileDistCP()) {
            partitionOutputPath = rootPath + "/rowkey_stats/part-r-00000_hfile";
            outputPath = rootPath + "/hfile/";
        }
        flinkExecutable.setParam(FlinkCubeHFile.OPTION_OUTPUT_PATH.getOpt(), outputPath);
        flinkExecutable.setParam(FlinkCubeHFile.OPTION_PARTITION_FILE_PATH.getOpt(), partitionOutputPath);
        flinkExecutable.setParam(AbstractHadoopJob.OPTION_HBASE_CONF_PATH.getOpt(), this.getHBaseConfFilePath(jobId));
        flinkExecutable.setJobId(jobId);
        StringBuilder jars = new StringBuilder();
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar(KeyValue.class));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar(HFileOutputFormat2.class));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar(BloomType.class));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar(HFileProtos.class));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar(CompatibilityFactory.class));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar("org.htrace.HTraceConfiguration", null));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar("org.apache.htrace.Trace", null));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar("com.yammer.metrics.core.MetricsRegistry", null));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar("org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory", null));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar("org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactoryImpl", null));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar("org.apache.hadoop.hbase.io.hfile.HFileWriterImpl", null));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar("org.apache.hbase.thirdparty.com.google.common.cache.CacheLoader", null));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar("org.apache.hadoop.hbase.metrics.MetricRegistry", null));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar("org.apache.hadoop.hbase.metrics.impl.MetricRegistriesImpl", null));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar("org.apache.hbase.thirdparty.com.google.protobuf.Message", null));
        StringUtil.appendWithSeparator(jars, ClassUtil.findContainingJar("org.apache.hadoop.hbase.shaded.protobuf.generated.HFileProtos", null));
        if (!StringUtil.isEmpty(this.seg.getConfig().getFlinkAdditionalJars())) {
            StringUtil.appendWithSeparator(jars, this.seg.getConfig().getFlinkAdditionalJars());
        }
        flinkExecutable.setJars(jars.toString());
        flinkExecutable.setName("Convert Cuboid Data to HFile");
        flinkExecutable.setCounterSaveAs(",,byteSizeBytes", this.getCounterOutputPath(jobId));
        return flinkExecutable;
    }
}

