/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;

public class OLAPJoinPushThroughJoinRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new OLAPJoinPushThroughJoinRule("OLAPJoinPushThroughJoinRule", LogicalJoin.class, RelFactories.LOGICAL_BUILDER);

    public OLAPJoinPushThroughJoinRule(String description, Class<? extends Join> clazz, RelBuilderFactory relBuilderFactory) {
        super(OLAPJoinPushThroughJoinRule.operand(clazz, OLAPJoinPushThroughJoinRule.operand(clazz, OLAPJoinPushThroughJoinRule.operand(RelNode.class, OLAPJoinPushThroughJoinRule.any()), OLAPJoinPushThroughJoinRule.operand(RelNode.class, null, new Predicate<RelNode>(){

            @Override
            public boolean apply(@Nullable RelNode relNode) {
                return !(relNode instanceof TableScan);
            }
        }, OLAPJoinPushThroughJoinRule.any())), OLAPJoinPushThroughJoinRule.operand(TableScan.class, OLAPJoinPushThroughJoinRule.any())), relBuilderFactory, description);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        this.onMatchRight(call);
    }

    private void onMatchRight(RelOptRuleCall call) {
        Join topJoin = (Join)call.rel(0);
        Join bottomJoin = (Join)call.rel(1);
        Object relC = call.rel(4);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelOptCluster cluster = topJoin.getCluster();
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        ImmutableBitSet bBitSet = ImmutableBitSet.range(aCount, aCount + bCount);
        ArrayList<RexNode> intersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> nonIntersecting = new ArrayList<RexNode>();
        OLAPJoinPushThroughJoinRule.split(topJoin.getCondition(), bBitSet, intersecting, nonIntersecting);
        if (nonIntersecting.isEmpty()) {
            return;
        }
        ArrayList<RexNode> bottomIntersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> bottomNonIntersecting = new ArrayList<RexNode>();
        OLAPJoinPushThroughJoinRule.split(bottomJoin.getCondition(), bBitSet, bottomIntersecting, bottomNonIntersecting);
        Mappings.TargetMapping bottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount + cCount, aCount, bCount, aCount, aCount + bCount, cCount);
        ArrayList<RexNode> newBottomList = new ArrayList<RexNode>();
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relA, relC}).visitList(nonIntersecting, newBottomList);
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relA, relC}).visitList(bottomNonIntersecting, newBottomList);
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList, false);
        Join newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, relA, (RelNode)relC, bottomJoin.getJoinType(), bottomJoin.isSemiJoinDone());
        Mappings.TargetMapping topMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount + cCount, aCount, bCount, aCount, aCount + bCount, cCount);
        ArrayList<RexNode> newTopList = new ArrayList<RexNode>();
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relB).visitList(intersecting, newTopList);
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relB).visitList(bottomIntersecting, newTopList);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, newTopList, false);
        Join newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, newBottomJoin, relB, topJoin.getJoinType(), topJoin.isSemiJoinDone());
        assert (!Mappings.isIdentity(topMapping));
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newTopJoin);
        relBuilder.project(relBuilder.fields(topMapping));
        call.transformTo(relBuilder.build());
    }

    static void split(RexNode condition, ImmutableBitSet bitSet, List<RexNode> intersecting, List<RexNode> nonIntersecting) {
        for (RexNode node : RelOptUtil.conjunctions(condition)) {
            ImmutableBitSet inputBitSet = RelOptUtil.InputFinder.bits(node);
            if (bitSet.intersects(inputBitSet)) {
                intersecting.add(node);
                continue;
            }
            nonIntersecting.add(node);
        }
    }
}

