/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapred.utils;

import java.io.File;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);

    public static void mergeHadoopConf(JobConf jobConf) {
        Configuration flinkConfiguration = GlobalConfiguration.loadConfiguration();
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopUtils.getHadoopConfiguration(flinkConfiguration);
        for (Map.Entry e : hadoopConf) {
            if (jobConf.get((String)e.getKey()) != null) continue;
            jobConf.set((String)e.getKey(), (String)e.getValue());
        }
    }

    public static org.apache.hadoop.conf.Configuration getHadoopConfiguration(Configuration flinkConfiguration) {
        org.apache.hadoop.conf.Configuration retConf = new org.apache.hadoop.conf.Configuration();
        String hdfsDefaultPath = flinkConfiguration.getString("fs.hdfs.hdfsdefault", null);
        if (hdfsDefaultPath != null) {
            retConf.addResource(new Path(hdfsDefaultPath));
        } else {
            LOG.debug("Cannot find hdfs-default configuration file");
        }
        String hdfsSitePath = flinkConfiguration.getString("fs.hdfs.hdfssite", null);
        if (hdfsSitePath != null) {
            retConf.addResource(new Path(hdfsSitePath));
        } else {
            LOG.debug("Cannot find hdfs-site configuration file");
        }
        String[] possibleHadoopConfPaths = new String[4];
        possibleHadoopConfPaths[0] = flinkConfiguration.getString("fs.hdfs.hadoopconf", null);
        possibleHadoopConfPaths[1] = System.getenv("HADOOP_CONF_DIR");
        if (System.getenv("HADOOP_HOME") != null) {
            possibleHadoopConfPaths[2] = System.getenv("HADOOP_HOME") + "/conf";
            possibleHadoopConfPaths[3] = System.getenv("HADOOP_HOME") + "/etc/hadoop";
        }
        for (String possibleHadoopConfPath : possibleHadoopConfPaths) {
            if (possibleHadoopConfPath == null || !new File(possibleHadoopConfPath).exists()) continue;
            if (new File(possibleHadoopConfPath + "/core-site.xml").exists()) {
                retConf.addResource(new Path(possibleHadoopConfPath + "/core-site.xml"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding " + possibleHadoopConfPath + "/core-site.xml to hadoop configuration");
                }
            }
            if (!new File(possibleHadoopConfPath + "/hdfs-site.xml").exists()) continue;
            retConf.addResource(new Path(possibleHadoopConfPath + "/hdfs-site.xml"));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Adding " + possibleHadoopConfPath + "/hdfs-site.xml to hadoop configuration");
        }
        return retConf;
    }

    private HadoopUtils() {
        throw new RuntimeException();
    }
}

