/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoopcompatibility;

import java.io.IOException;
import org.apache.flink.api.java.hadoop.mapred.HadoopInputFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;

public final class HadoopInputs {
    public static <K, V> HadoopInputFormat<K, V> readHadoopFile(FileInputFormat<K, V> mapredInputFormat, Class<K> key, Class<V> value, String inputPath, JobConf job) {
        FileInputFormat.addInputPath((JobConf)job, (Path)new Path(inputPath));
        return HadoopInputs.createHadoopInput(mapredInputFormat, key, value, job);
    }

    public static <K, V> HadoopInputFormat<K, V> readHadoopFile(FileInputFormat<K, V> mapredInputFormat, Class<K> key, Class<V> value, String inputPath) {
        return HadoopInputs.readHadoopFile(mapredInputFormat, key, value, inputPath, new JobConf());
    }

    public static <K, V> HadoopInputFormat<K, V> readSequenceFile(Class<K> key, Class<V> value, String inputPath) throws IOException {
        return HadoopInputs.readHadoopFile(new SequenceFileInputFormat(), key, value, inputPath);
    }

    public static <K, V> HadoopInputFormat<K, V> createHadoopInput(org.apache.hadoop.mapred.InputFormat<K, V> mapredInputFormat, Class<K> key, Class<V> value, JobConf job) {
        return new HadoopInputFormat<K, V>(mapredInputFormat, key, value, job);
    }

    public static <K, V> org.apache.flink.api.java.hadoop.mapreduce.HadoopInputFormat<K, V> readHadoopFile(org.apache.hadoop.mapreduce.lib.input.FileInputFormat<K, V> mapreduceInputFormat, Class<K> key, Class<V> value, String inputPath, Job job) throws IOException {
        org.apache.hadoop.mapreduce.lib.input.FileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
        return HadoopInputs.createHadoopInput(mapreduceInputFormat, key, value, job);
    }

    public static <K, V> org.apache.flink.api.java.hadoop.mapreduce.HadoopInputFormat<K, V> readHadoopFile(org.apache.hadoop.mapreduce.lib.input.FileInputFormat<K, V> mapreduceInputFormat, Class<K> key, Class<V> value, String inputPath) throws IOException {
        return HadoopInputs.readHadoopFile(mapreduceInputFormat, key, value, inputPath, Job.getInstance());
    }

    public static <K, V> org.apache.flink.api.java.hadoop.mapreduce.HadoopInputFormat<K, V> createHadoopInput(InputFormat<K, V> mapreduceInputFormat, Class<K> key, Class<V> value, Job job) {
        return new org.apache.flink.api.java.hadoop.mapreduce.HadoopInputFormat<K, V>(mapreduceInputFormat, key, value, job);
    }
}

