/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.TooManyCuboidException;
import org.apache.kylin.shaded.com.google.common.base.Predicate;
import org.apache.kylin.shaded.com.google.common.collect.Iterators;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

public class DefaultCuboidScheduler
extends CuboidScheduler {
    private final long max;
    private final Set<Long> allCuboidIds;
    private final Map<Long, List<Long>> parent2child;

    public DefaultCuboidScheduler(CubeDesc cubeDesc) {
        super(cubeDesc);
        int size = this.cubeDesc.getRowkey().getRowKeyColumns().length;
        this.max = (long)Math.pow(2.0, size) - 1L;
        Pair<Set<Long>, Map<Long, List<Long>>> pair = this.buildTreeBottomUp();
        this.allCuboidIds = pair.getFirst();
        this.parent2child = pair.getSecond();
    }

    @Override
    public int getCuboidCount() {
        return this.allCuboidIds.size();
    }

    @Override
    public List<Long> getSpanningCuboid(long cuboid) {
        if (cuboid > this.max || cuboid < 0L) {
            throw new IllegalArgumentException("Cuboid " + cuboid + " is out of scope 0-" + this.max);
        }
        List<Long> spanning = this.parent2child.get(cuboid);
        if (spanning == null) {
            return Collections.EMPTY_LIST;
        }
        return spanning;
    }

    @Override
    public Set<Long> getAllCuboidIds() {
        return Sets.newHashSet(this.allCuboidIds);
    }

    @Override
    public boolean isValid(long requestCuboid) {
        return this.allCuboidIds.contains(requestCuboid);
    }

    @Override
    public long findBestMatchCuboid(long cuboid) {
        return this.findBestMatchCuboid1(cuboid);
    }

    long findBestMatchCuboid1(long cuboid) {
        if (this.isValid(cuboid)) {
            return cuboid;
        }
        ArrayList<Long> onTreeCandidates = Lists.newArrayList();
        for (AggregationGroup agg : this.cubeDesc.getAggregationGroups()) {
            Long candidate = agg.translateToOnTreeCuboid(cuboid);
            if (candidate == null) continue;
            onTreeCandidates.add(candidate);
        }
        if (onTreeCandidates.size() == 0) {
            return this.getBaseCuboidId();
        }
        long onTreeCandi = Collections.min(onTreeCandidates, Cuboid.cuboidSelectComparator);
        if (this.isValid(onTreeCandi)) {
            return onTreeCandi;
        }
        return this.doFindBestMatchCuboid1(onTreeCandi);
    }

    private long doFindBestMatchCuboid1(long cuboid) {
        long parent = this.getOnTreeParent(cuboid);
        while (parent > 0L && !this.cubeDesc.getAllCuboids().contains(parent)) {
            parent = this.getOnTreeParent(parent);
        }
        if (parent <= 0L) {
            throw new IllegalStateException("Can't find valid parent for Cuboid " + cuboid);
        }
        return parent;
    }

    private long getOnTreeParent(long child) {
        Set<Long> candidates = this.getOnTreeParents(child);
        if (candidates == null || candidates.isEmpty()) {
            return -1L;
        }
        return Collections.min(candidates, Cuboid.cuboidSelectComparator);
    }

    private Set<Long> getOnTreeParents(long child) {
        ArrayList<AggregationGroup> aggrs = Lists.newArrayList();
        for (AggregationGroup agg : this.cubeDesc.getAggregationGroups()) {
            if (!agg.isOnTree(child)) continue;
            aggrs.add(agg);
        }
        return this.getOnTreeParents(child, aggrs);
    }

    protected Pair<Set<Long>, Map<Long, List<Long>>> buildTreeBottomUp() {
        int forward = this.cubeDesc.getParentForward();
        KylinConfig config = this.cubeDesc.getConfig();
        HashSet<Object> cuboidHolder = new HashSet<Long>();
        Set<Long> children = this.getLowestCuboids();
        long maxCombination = config.getCubeAggrGroupMaxCombination() * 10L;
        long l = maxCombination = maxCombination < 0L ? Long.MAX_VALUE : maxCombination;
        while (!children.isEmpty()) {
            cuboidHolder.addAll(children);
            if ((long)cuboidHolder.size() > maxCombination) {
                throw new IllegalStateException("Too many cuboids for the cube. Cuboid combination reached " + cuboidHolder.size() + " and limit is " + maxCombination + ". Abort calculation.");
            }
            children = this.getOnTreeParentsByLayer(children);
        }
        cuboidHolder.add(Cuboid.getBaseCuboidId(this.cubeDesc));
        cuboidHolder = Sets.newHashSet(Iterators.filter(cuboidHolder.iterator(), new Predicate<Long>(){

            @Override
            public boolean apply(@Nullable Long cuboidId) {
                return !DefaultCuboidScheduler.this.cubeDesc.isBlackedCuboid(cuboidId);
            }
        }));
        HashMap<Long, ArrayList<Long>> parent2Child = Maps.newHashMap();
        ArrayDeque<Object> cuboidScan = new ArrayDeque<Object>();
        cuboidScan.addAll(cuboidHolder);
        while (!cuboidScan.isEmpty()) {
            long current = (Long)cuboidScan.poll();
            long parent = this.getParentOnPromise(current, cuboidHolder, forward);
            if (parent <= 0L) continue;
            if (!cuboidHolder.contains(parent)) {
                cuboidScan.add(parent);
                cuboidHolder.add(parent);
            }
            if (parent2Child.containsKey(parent)) {
                ((List)parent2Child.get(parent)).add(current);
                continue;
            }
            parent2Child.put(parent, Lists.newArrayList(current));
        }
        return Pair.newPair(cuboidHolder, parent2Child);
    }

    private long getParentOnPromise(long child, Set<Long> coll, int forward) {
        long parent = this.getOnTreeParent(child);
        if (parent < 0L) {
            return -1L;
        }
        if (coll.contains(parent) || forward == 0) {
            return parent;
        }
        return this.getParentOnPromise(parent, coll, forward - 1);
    }

    private Set<Long> getOnTreeParentsByLayer(Collection<Long> children) {
        HashSet<Long> parents = new HashSet<Long>();
        for (long child : children) {
            parents.addAll(this.getOnTreeParents(child));
        }
        parents = Sets.newHashSet(Iterators.filter(parents.iterator(), new Predicate<Long>(){

            @Override
            public boolean apply(@Nullable Long cuboidId) {
                if (cuboidId == Cuboid.getBaseCuboidId(DefaultCuboidScheduler.this.cubeDesc)) {
                    return true;
                }
                for (AggregationGroup agg : DefaultCuboidScheduler.this.cubeDesc.getAggregationGroups()) {
                    if (!agg.isOnTree(cuboidId) || !DefaultCuboidScheduler.this.checkDimCap(agg, cuboidId)) continue;
                    return true;
                }
                return false;
            }
        }));
        return parents;
    }

    private Set<Long> getLowestCuboids() {
        return this.getOnTreeParents(0L, this.cubeDesc.getAggregationGroups());
    }

    private Set<Long> getOnTreeParents(long child, Collection<AggregationGroup> groups) {
        HashSet<Long> parentCandidate = new HashSet<Long>();
        if (child == Cuboid.getBaseCuboidId(this.cubeDesc)) {
            return parentCandidate;
        }
        for (AggregationGroup agg : groups) {
            if (child == agg.getPartialCubeFullMask()) {
                parentCandidate.add(Cuboid.getBaseCuboidId(this.cubeDesc));
                return parentCandidate;
            }
            parentCandidate.addAll(this.getOnTreeParents(child, agg));
        }
        return parentCandidate;
    }

    @Override
    public Set<Long> calculateCuboidsForAggGroup(AggregationGroup agg) {
        HashSet<Long> cuboidHolder = new HashSet<Long>();
        Set<Long> children = this.getLowestCuboids(agg);
        while (!children.isEmpty()) {
            if ((long)cuboidHolder.size() > this.cubeDesc.getConfig().getCubeAggrGroupMaxCombination()) {
                throw new TooManyCuboidException("Holder size larger than kylin.cube.aggrgroup.max-combination");
            }
            cuboidHolder.addAll(children);
            children = this.getOnTreeParentsByLayer(children, agg);
        }
        return Sets.newHashSet(Iterators.filter(cuboidHolder.iterator(), new Predicate<Long>(){

            @Override
            public boolean apply(@Nullable Long cuboidId) {
                return !DefaultCuboidScheduler.this.cubeDesc.isBlackedCuboid(cuboidId);
            }
        }));
    }

    private Set<Long> getOnTreeParentsByLayer(Collection<Long> children, final AggregationGroup agg) {
        HashSet<Long> parents = new HashSet<Long>();
        for (long child : children) {
            parents.addAll(this.getOnTreeParents(child, agg));
        }
        parents = Sets.newHashSet(Iterators.filter(parents.iterator(), new Predicate<Long>(){

            @Override
            public boolean apply(@Nullable Long cuboidId) {
                return DefaultCuboidScheduler.this.checkDimCap(agg, cuboidId);
            }
        }));
        return parents;
    }

    private Set<Long> getLowestCuboids(AggregationGroup agg) {
        return this.getOnTreeParents(0L, agg);
    }

    private Set<Long> getOnTreeParents(long child, AggregationGroup agg) {
        HashSet<Long> parentCandidate = new HashSet<Long>();
        long tmpChild = child;
        if (tmpChild == agg.getPartialCubeFullMask()) {
            return parentCandidate;
        }
        if (agg.getMandatoryColumnMask() != 0L) {
            if (agg.isMandatoryOnlyValid()) {
                if (this.fillBit(tmpChild, agg.getMandatoryColumnMask(), parentCandidate)) {
                    return parentCandidate;
                }
            } else {
                tmpChild |= agg.getMandatoryColumnMask();
            }
        }
        for (Long normal : agg.getNormalDims()) {
            this.fillBit(tmpChild, normal, parentCandidate);
        }
        for (Long joint : agg.getJoints()) {
            this.fillBit(tmpChild, joint, parentCandidate);
        }
        for (AggregationGroup.HierarchyMask hierarchy : agg.getHierarchyMasks()) {
            for (long mask : hierarchy.allMasks) {
                if (this.fillBit(tmpChild, mask, parentCandidate)) break;
            }
        }
        return parentCandidate;
    }

    private boolean fillBit(long origin, long other, Set<Long> coll) {
        if ((origin & other) != other) {
            coll.add(origin | other);
            return true;
        }
        return false;
    }

    private boolean checkDimCap(AggregationGroup agg, long cuboidID) {
        int dimCap = agg.getDimCap();
        if (dimCap <= 0) {
            return true;
        }
        return Long.bitCount(cuboidID) <= dimCap;
    }

    long findBestMatchCuboid2(long cuboid) {
        long bestParent = this.doFindBestMatchCuboid2(cuboid, Cuboid.getBaseCuboidId(this.cubeDesc));
        if (bestParent < -1L) {
            throw new IllegalStateException("Cannot find the parent of the cuboid:" + cuboid);
        }
        return bestParent;
    }

    private long doFindBestMatchCuboid2(long cuboid, long parent) {
        if (!this.canDerive(cuboid, parent)) {
            return -1L;
        }
        List<Long> children = this.parent2child.get(parent);
        ArrayList<Long> candidates = Lists.newArrayList();
        if (children != null) {
            for (long child : children) {
                long candidate = this.doFindBestMatchCuboid2(cuboid, child);
                if (candidate <= 0L) continue;
                candidates.add(candidate);
            }
        }
        if (candidates.isEmpty()) {
            candidates.add(parent);
        }
        return Collections.min(candidates, Cuboid.cuboidSelectComparator);
    }

    private boolean canDerive(long cuboidId, long parentCuboid) {
        return (cuboidId & (parentCuboid ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }
}

