/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import java.util.Map;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.inmemcubing.InputConverterUnit;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.cube.util.KeyValueBuilder;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputConverterUnitForRawData
implements InputConverterUnit<String[]> {
    private static final Logger logger = LoggerFactory.getLogger(InputConverterUnitForRawData.class);
    public static final String[] END_ROW = new String[0];
    public static final String[] CUT_ROW = new String[]{""};
    private final CubeJoinedFlatTableEnrich flatDesc;
    private final MeasureDesc[] measureDescs;
    private final MeasureIngester<?>[] measureIngesters;
    private final int measureCount;
    private final Map<TblColRef, Dictionary<String>> dictionaryMap;
    private final KeyValueBuilder kvBuilder;

    public InputConverterUnitForRawData(CubeDesc cubeDesc, IJoinedFlatTableDesc flatDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        this.flatDesc = new CubeJoinedFlatTableEnrich(flatDesc, cubeDesc);
        this.measureCount = cubeDesc.getMeasures().size();
        this.measureDescs = cubeDesc.getMeasures().toArray(new MeasureDesc[this.measureCount]);
        this.measureIngesters = MeasureIngester.create(cubeDesc.getMeasures());
        this.dictionaryMap = dictionaryMap;
        this.kvBuilder = new KeyValueBuilder(this.flatDesc);
    }

    @Override
    public final void convert(String[] row, GTRecord record) {
        String[] dimensions = this.kvBuilder.buildKey(row);
        Object[] metricsValues = this.buildValue(row);
        Object[] recordValues = new Object[dimensions.length + metricsValues.length];
        System.arraycopy(dimensions, 0, recordValues, 0, dimensions.length);
        System.arraycopy(metricsValues, 0, recordValues, dimensions.length, metricsValues.length);
        record.setValues(recordValues);
    }

    @Override
    public boolean ifEnd(String[] currentObject) {
        return currentObject == END_ROW;
    }

    @Override
    public boolean ifCut(String[] currentObject) {
        return currentObject == CUT_ROW;
    }

    @Override
    public String[] getEndRow() {
        return END_ROW;
    }

    @Override
    public String[] getCutRow() {
        return CUT_ROW;
    }

    @Override
    public boolean ifChange() {
        return true;
    }

    private Object[] buildValue(String[] row) {
        Object[] values = new Object[this.measureCount];
        for (int i = 0; i < this.measureCount; ++i) {
            String[] colValues = this.kvBuilder.buildValueOf(i, row);
            MeasureDesc measure = this.measureDescs[i];
            values[i] = this.measureIngesters[i].valueOf(colValues, measure, this.dictionaryMap);
        }
        return values;
    }
}

