/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import org.apache.kylin.cube.inmemcubing.ConsumeBlockingQueueController;
import org.apache.kylin.cube.inmemcubing.InputConverterUnit;

public class RecordConsumeBlockingQueueController<T>
extends ConsumeBlockingQueueController<T> {
    public final InputConverterUnit<T> inputConverterUnit;
    private T currentObject = null;
    private volatile boolean ifEnd = false;

    private RecordConsumeBlockingQueueController(InputConverterUnit<T> inputConverterUnit, BlockingQueue<T> input, int batchSize) {
        super(input, batchSize);
        this.inputConverterUnit = inputConverterUnit;
    }

    @Override
    public boolean hasNext() {
        if (this.ifEnd) {
            return false;
        }
        if (this.currentObject != null) {
            return true;
        }
        if (!super.hasNext()) {
            return false;
        }
        this.currentObject = super.next();
        if (this.inputConverterUnit.ifEnd(this.currentObject)) {
            this.ifEnd = true;
            return false;
        }
        if (this.inputConverterUnit.ifCut(this.currentObject)) {
            this.currentObject = null;
            this.hasNext();
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (this.ifEnd() || this.currentObject == null) {
            throw new NoSuchElementException();
        }
        T result = this.currentObject;
        this.currentObject = null;
        return result;
    }

    public boolean ifEnd() {
        return this.ifEnd;
    }

    public static <T> RecordConsumeBlockingQueueController<T> getQueueController(InputConverterUnit<T> inputConverterUnit, BlockingQueue<T> input) {
        return new RecordConsumeBlockingQueueController<T>(inputConverterUnit, input, 1000);
    }

    public static <T> RecordConsumeBlockingQueueController<T> getQueueController(InputConverterUnit<T> inputConverterUnit, BlockingQueue<T> input, int batchSize) {
        return new RecordConsumeBlockingQueueController<T>(inputConverterUnit, input, batchSize);
    }
}

