/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.MemoryBudgetController;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.gridtable.CubeGridTable;
import org.apache.kylin.cube.inmemcubing.AbstractInMemCubeBuilder;
import org.apache.kylin.cube.inmemcubing.ConcurrentDiskStore;
import org.apache.kylin.cube.inmemcubing.CuboidResult;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.cube.inmemcubing.InMemCubeBuilderUtils;
import org.apache.kylin.cube.inmemcubing.InputConverter;
import org.apache.kylin.cube.inmemcubing.InputConverterUnit;
import org.apache.kylin.cube.inmemcubing.RecordConsumeBlockingQueueController;
import org.apache.kylin.cube.inmemcubing2.CuboidTask;
import org.apache.kylin.cube.inmemcubing2.DefaultCuboidCollectorWithCallBack;
import org.apache.kylin.cube.inmemcubing2.ICuboidCollectorWithCallBack;
import org.apache.kylin.cube.inmemcubing2.ICuboidResultListener;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.gridtable.GTAggregateScanner;
import org.apache.kylin.gridtable.GTBuilder;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GTScanRequestBuilder;
import org.apache.kylin.gridtable.GridTable;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Stopwatch;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemCubeBuilder2
extends AbstractInMemCubeBuilder {
    private static Logger logger = LoggerFactory.getLogger(InMemCubeBuilder2.class);
    private static final double DERIVE_AGGR_CACHE_CONSTANT_FACTOR = 0.1;
    private static final double DERIVE_AGGR_CACHE_VARIABLE_FACTOR = 0.9;
    protected final String[] metricsAggrFuncs;
    protected final MeasureDesc[] measureDescs;
    protected final int measureCount;
    private MemoryBudgetController memBudget;
    protected final long baseCuboidId;
    private CuboidResult baseResult;
    private Queue<CuboidTask> completedTaskQueue;
    private AtomicInteger taskCuboidCompleted;
    private ICuboidCollectorWithCallBack resultCollector;

    public InMemCubeBuilder2(CuboidScheduler cuboidScheduler, IJoinedFlatTableDesc flatDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        super(cuboidScheduler, flatDesc, dictionaryMap);
        this.measureCount = this.cubeDesc.getMeasures().size();
        this.measureDescs = this.cubeDesc.getMeasures().toArray(new MeasureDesc[this.measureCount]);
        ArrayList<String> metricsAggrFuncsList = Lists.newArrayList();
        for (int i = 0; i < this.measureCount; ++i) {
            MeasureDesc measureDesc = this.measureDescs[i];
            metricsAggrFuncsList.add(measureDesc.getFunction().getExpression());
        }
        this.metricsAggrFuncs = metricsAggrFuncsList.toArray(new String[metricsAggrFuncsList.size()]);
        this.baseCuboidId = Cuboid.getBaseCuboidId(this.cubeDesc);
    }

    public int getBaseResultCacheMB() {
        return this.baseResult.getAggrCacheMB();
    }

    private GridTable newGridTableByCuboidID(long cuboidID) throws IOException {
        GTInfo info = CubeGridTable.newGTInfo(Cuboid.findForMandatory(this.cubeDesc, cuboidID), new CubeDimEncMap(this.cubeDesc, this.dictionaryMap));
        ConcurrentDiskStore store = new ConcurrentDiskStore(info);
        GridTable gridTable = new GridTable(info, store);
        return gridTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void build(BlockingQueue<T> input, InputConverterUnit<T> inputConverterUnit, ICuboidWriter output) throws IOException {
        NavigableMap<Long, CuboidResult> result = this.buildAndCollect(RecordConsumeBlockingQueueController.getQueueController(inputConverterUnit, input), null);
        try {
            for (CuboidResult cuboidResult : result.values()) {
                this.outputCuboid(cuboidResult.cuboidId, cuboidResult.table, output);
                cuboidResult.table.close();
            }
        }
        finally {
            output.close();
        }
    }

    private <T> NavigableMap<Long, CuboidResult> buildAndCollect(RecordConsumeBlockingQueueController<T> input, ICuboidResultListener listener) throws IOException {
        long startTime = System.currentTimeMillis();
        logger.info("In Mem Cube Build2 start, {}", (Object)this.cubeDesc.getName());
        this.buildBaseCuboid(input, listener);
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName("inmem-cubing-cuboid-worker-" + worker.getPoolIndex());
                return worker;
            }
        };
        ForkJoinPool builderPool = new ForkJoinPool(this.taskThreadCount, factory, null, true);
        Future rootTask = builderPool.submit(new Runnable(){

            @Override
            public void run() {
                InMemCubeBuilder2.this.startBuildFromBaseCuboid();
            }
        });
        ((ForkJoinTask)rootTask).join();
        long endTime = System.currentTimeMillis();
        logger.info("In Mem Cube Build2 end, {}, takes {} ms", (Object)this.cubeDesc.getName(), (Object)(endTime - startTime));
        logger.info("total CuboidResult count: {}", (Object)this.resultCollector.getAllResult().size());
        return this.resultCollector.getAllResult();
    }

    public ICuboidCollectorWithCallBack getResultCollector() {
        return this.resultCollector;
    }

    public <T> CuboidResult buildBaseCuboid(RecordConsumeBlockingQueueController<T> input, ICuboidResultListener listener) throws IOException {
        this.completedTaskQueue = new LinkedBlockingQueue<CuboidTask>();
        this.taskCuboidCompleted = new AtomicInteger(0);
        this.resultCollector = new DefaultCuboidCollectorWithCallBack(listener);
        MemoryBudgetController.MemoryWaterLevel baseCuboidMemTracker = new MemoryBudgetController.MemoryWaterLevel();
        baseCuboidMemTracker.markLow();
        this.baseResult = this.createBaseCuboid(input, baseCuboidMemTracker);
        if (this.baseResult.nRows == 0) {
            this.taskCuboidCompleted.set(this.cuboidScheduler.getCuboidCount());
            return this.baseResult;
        }
        baseCuboidMemTracker.markLow();
        this.baseResult.setAggrCacheMB(Math.max(baseCuboidMemTracker.getEstimateMB(), 10));
        this.makeMemoryBudget();
        return this.baseResult;
    }

    public CuboidResult buildCuboid(CuboidTask task) throws IOException {
        CuboidResult newCuboid = this.buildCuboid(task.parent, task.childCuboidId);
        this.completedTaskQueue.add(task);
        this.addChildTasks(newCuboid);
        return newCuboid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CuboidResult buildCuboid(CuboidResult parent, long cuboidId) throws IOException {
        final String consumerName = "AggrCache@Cuboid " + cuboidId;
        MemoryBudgetController.MemoryConsumer consumer = new MemoryBudgetController.MemoryConsumer(){

            @Override
            public int freeUp(int mb) {
                return 0;
            }

            public String toString() {
                return consumerName;
            }
        };
        this.memBudget.reserveInsist(consumer, parent.getAggrCacheMB());
        try {
            CuboidResult cuboidResult = this.aggregateCuboid(parent, cuboidId);
            return cuboidResult;
        }
        finally {
            this.memBudget.reserve(consumer, 0);
        }
    }

    public boolean isAllCuboidDone() {
        return this.taskCuboidCompleted.get() == this.cuboidScheduler.getCuboidCount();
    }

    public void startBuildFromBaseCuboid() {
        this.addChildTasks(this.baseResult);
    }

    private void addChildTasks(CuboidResult parent) {
        List<Long> children = this.cuboidScheduler.getSpanningCuboid(parent.cuboidId);
        if (children != null && !children.isEmpty()) {
            ArrayList<CuboidTask> childTasks = Lists.newArrayListWithExpectedSize(children.size());
            for (Long child : children) {
                CuboidTask task = new CuboidTask(parent, child, this);
                childTasks.add(task);
                task.fork();
            }
            for (CuboidTask childTask : childTasks) {
                childTask.join();
            }
        }
    }

    public Queue<CuboidTask> getCompletedTaskQueue() {
        return this.completedTaskQueue;
    }

    private void makeMemoryBudget() {
        int systemAvailMB = MemoryBudgetController.gcAndGetSystemAvailMB();
        logger.info("System avail {} MB", (Object)systemAvailMB);
        int reserve = this.reserveMemoryMB;
        logger.info("Reserve {} MB for system basics", (Object)reserve);
        int budget = systemAvailMB - reserve;
        if (budget < this.baseResult.getAggrCacheMB()) {
            budget = this.baseResult.getAggrCacheMB();
            logger.warn("System avail memory ({} MB) is less than base aggr cache ({} MB) + minimal reservation ({} MB), consider increase JVM heap -Xmx", systemAvailMB, this.baseResult.getAggrCacheMB(), reserve);
        }
        logger.info("Memory Budget is {} MB", (Object)budget);
        this.memBudget = new MemoryBudgetController(budget);
    }

    private <T> CuboidResult createBaseCuboid(RecordConsumeBlockingQueueController<T> input, MemoryBudgetController.MemoryWaterLevel baseCuboidMemTracker) throws IOException {
        logger.info("Calculating base cuboid {}", (Object)this.baseCuboidId);
        Stopwatch sw = Stopwatch.createUnstarted();
        sw.start();
        GridTable baseCuboid = this.newGridTableByCuboidID(this.baseCuboidId);
        GTBuilder baseBuilder = baseCuboid.rebuild();
        InputConverter<T> baseInput = new InputConverter<T>(baseCuboid.getInfo(), input);
        Pair<ImmutableBitSet, ImmutableBitSet> dimensionMetricsBitSet = InMemCubeBuilderUtils.getDimensionAndMetricColumnBitSet(this.baseCuboidId, this.measureCount);
        GTScanRequest req = new GTScanRequestBuilder().setInfo(baseCuboid.getInfo()).setRanges(null).setDimensions(null).setAggrGroupBy(dimensionMetricsBitSet.getFirst()).setAggrMetrics(dimensionMetricsBitSet.getSecond()).setAggrMetricsFuncs(this.metricsAggrFuncs).setFilterPushDown(null).createGTScanRequest();
        try (GTAggregateScanner aggregationScanner = new GTAggregateScanner(baseInput, req);){
            aggregationScanner.trackMemoryLevel(baseCuboidMemTracker);
            int count = 0;
            for (GTRecord r : aggregationScanner) {
                if (count == 0) {
                    baseCuboidMemTracker.markHigh();
                }
                baseBuilder.write(r);
                ++count;
            }
            baseBuilder.close();
            sw.stop();
            logger.info("Cuboid {} has {} rows, build takes {}ms", this.baseCuboidId, count, sw.elapsed(TimeUnit.MILLISECONDS));
            int mbEstimateBaseAggrCache = (int)(aggregationScanner.getEstimateSizeOfAggrCache() / 0x100000L);
            logger.info("Wild estimate of base aggr cache is {} MB", (Object)mbEstimateBaseAggrCache);
            CuboidResult cuboidResult = this.updateCuboidResult(this.baseCuboidId, baseCuboid, count, sw.elapsed(TimeUnit.MILLISECONDS), 0, input.inputConverterUnit.ifChange());
            return cuboidResult;
        }
    }

    private CuboidResult updateCuboidResult(long cuboidId, GridTable table, int nRows, long timeSpent, int aggrCacheMB) {
        return this.updateCuboidResult(cuboidId, table, nRows, timeSpent, aggrCacheMB, true);
    }

    private CuboidResult updateCuboidResult(long cuboidId, GridTable table, int nRows, long timeSpent, int aggrCacheMB, boolean ifCollect) {
        if (aggrCacheMB <= 0 && this.baseResult != null) {
            aggrCacheMB = (int)Math.round((0.1 + 0.9 * (double)nRows / (double)this.baseResult.nRows) * (double)this.baseResult.getAggrCacheMB());
        }
        CuboidResult result = new CuboidResult(cuboidId, table, nRows, timeSpent, aggrCacheMB);
        this.taskCuboidCompleted.incrementAndGet();
        if (ifCollect) {
            this.resultCollector.collectAndNotify(result);
        }
        return result;
    }

    protected CuboidResult aggregateCuboid(CuboidResult parent, long cuboidId) throws IOException {
        Pair<ImmutableBitSet, ImmutableBitSet> allNeededColumns = InMemCubeBuilderUtils.getDimensionAndMetricColumnBitSet(parent.cuboidId, cuboidId, this.measureCount);
        return this.scanAndAggregateGridTable(parent.table, this.newGridTableByCuboidID(cuboidId), parent.cuboidId, cuboidId, allNeededColumns.getFirst(), allNeededColumns.getSecond());
    }

    private GTAggregateScanner prepareGTAggregationScanner(GridTable gridTable, long parentId, long cuboidId, ImmutableBitSet aggregationColumns, ImmutableBitSet measureColumns) throws IOException {
        GTInfo info = gridTable.getInfo();
        GTScanRequest req = new GTScanRequestBuilder().setInfo(info).setRanges(null).setDimensions(null).setAggrGroupBy(aggregationColumns).setAggrMetrics(measureColumns).setAggrMetricsFuncs(this.metricsAggrFuncs).setFilterPushDown(null).createGTScanRequest();
        GTAggregateScanner scanner = (GTAggregateScanner)gridTable.scan(req);
        if (parentId != cuboidId) {
            boolean[] aggrMask = new boolean[this.measureDescs.length];
            for (int i = 0; i < this.measureDescs.length; ++i) {
                boolean bl = aggrMask[i] = !this.measureDescs[i].getFunction().getMeasureType().onlyAggrInBaseCuboid();
                if (aggrMask[i]) continue;
                logger.info("{} doesn't need aggregation.", (Object)this.measureDescs[i]);
            }
            scanner.setAggrMask(aggrMask);
        }
        return scanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CuboidResult scanAndAggregateGridTable(GridTable gridTable, GridTable newGridTable, long parentId, long cuboidId, ImmutableBitSet aggregationColumns, ImmutableBitSet measureColumns) throws IOException {
        Stopwatch sw = Stopwatch.createUnstarted();
        sw.start();
        logger.info("Calculating cuboid {}", (Object)cuboidId);
        GTAggregateScanner scanner = this.prepareGTAggregationScanner(gridTable, parentId, cuboidId, aggregationColumns, measureColumns);
        GTBuilder builder = newGridTable.rebuild();
        ImmutableBitSet allNeededColumns = aggregationColumns.or(measureColumns);
        GTRecord newRecord = new GTRecord(newGridTable.getInfo());
        int count = 0;
        try {
            for (GTRecord record : scanner) {
                ++count;
                for (int i = 0; i < allNeededColumns.trueBitCount(); ++i) {
                    int c = allNeededColumns.trueBitAt(i);
                    newRecord.set(i, record.get(c));
                }
                builder.write(newRecord);
            }
        }
        finally {
            scanner.close();
            builder.close();
        }
        sw.stop();
        logger.info("Cuboid {} has {} rows, build takes {}ms", cuboidId, count, sw.elapsed(TimeUnit.MILLISECONDS));
        return this.updateCuboidResult(cuboidId, newGridTable, count, sw.elapsed(TimeUnit.MILLISECONDS), 0);
    }
}

