/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DictionaryDesc
implements Serializable {
    @JsonProperty(value="column")
    private String column;
    @JsonProperty(value="reuse")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String reuseColumn;
    @JsonProperty(value="builder")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String builderClass;
    @JsonProperty(value="cube")
    private String cube;
    @JsonProperty(value="model")
    private String model;
    private TblColRef colRef;
    private TblColRef reuseColRef;

    void init(CubeDesc cubeDesc) {
        DataModelDesc model = cubeDesc.getModel();
        this.column = this.column.toUpperCase(Locale.ROOT);
        this.colRef = model.findColumn(this.column);
        if (this.reuseColumn != null) {
            this.reuseColumn = this.reuseColumn.toUpperCase(Locale.ROOT);
            this.reuseColRef = model.findColumn(this.reuseColumn);
        }
    }

    public TblColRef getColumnRef() {
        return this.colRef;
    }

    public TblColRef getResuseColumnRef() {
        return this.reuseColRef;
    }

    public String getBuilderClass() {
        return this.builderClass;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public String getReuseColumn() {
        return this.reuseColumn;
    }

    public boolean isDomain() {
        return Objects.isNull(this.reuseColRef) && Objects.nonNull(this.reuseColumn);
    }

    public static DictionaryDesc create(String column, String reuseColumn, String builderClass) {
        DictionaryDesc desc = new DictionaryDesc();
        desc.column = column;
        desc.reuseColumn = reuseColumn;
        desc.builderClass = builderClass;
        return desc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DictionaryDesc that = (DictionaryDesc)o;
        return Objects.equals(this.column, that.column) && Objects.equals(this.reuseColumn, that.reuseColumn) && Objects.equals(this.builderClass, that.builderClass) && Objects.equals(this.cube, that.cube) && Objects.equals(this.model, that.model);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.reuseColumn, this.builderClass, this.cube, this.model);
    }
}

