/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.metadata.model.MeasureDesc;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class HBaseColumnFamilyDesc
implements Serializable {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="columns")
    private HBaseColumnDesc[] columns;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HBaseColumnDesc[] getColumns() {
        return this.columns;
    }

    public void setColumns(HBaseColumnDesc[] columns) {
        this.columns = columns;
    }

    public String toString() {
        return "HBaseColumnFamilyDesc [name=" + this.name + ", columns=" + Arrays.toString(this.columns) + "]";
    }

    public boolean isMemoryHungry() {
        for (HBaseColumnDesc hBaseColumnDesc : this.columns) {
            for (MeasureDesc measureDesc : hBaseColumnDesc.getMeasures()) {
                if (!measureDesc.getFunction().getMeasureType().isMemoryHungry()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HBaseColumnFamilyDesc that = (HBaseColumnFamilyDesc)o;
        return Objects.equals(this.name, that.name) && Arrays.equals(this.columns, that.columns);
    }

    public int hashCode() {
        int result = Objects.hash(this.name);
        result = 31 * result + Arrays.hashCode(this.columns);
        return result;
    }
}

