/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.kylin.common.util.Bytes;

public class ByteArrayWritable
implements WritableComparable<ByteArrayWritable> {
    private byte[] data;
    private int offset;
    private int length;

    public ByteArrayWritable() {
        this(null, 0, 0);
    }

    public ByteArrayWritable(int capacity) {
        this(new byte[capacity], 0, capacity);
    }

    public ByteArrayWritable(byte[] data) {
        this(data, 0, data == null ? 0 : data.length);
    }

    public ByteArrayWritable(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public byte[] array() {
        return this.data;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public void set(byte[] array) {
        this.set(array, 0, array.length);
    }

    public void set(byte[] array, int offset, int length) {
        this.data = array;
        this.offset = offset;
        this.length = length;
    }

    public ByteBuffer asBuffer() {
        if (this.data == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.data.length) {
            return ByteBuffer.wrap(this.data);
        }
        return ByteBuffer.wrap(this.data, this.offset, this.length).slice();
    }

    public int hashCode() {
        if (this.data == null) {
            return 0;
        }
        return Bytes.hashCode(this.data, this.offset, this.length);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.length);
        out.write(this.data, this.offset, this.length);
    }

    public void readFields(DataInput in) throws IOException {
        this.length = in.readInt();
        this.data = new byte[this.length];
        in.readFully(this.data, 0, this.length);
        this.offset = 0;
    }

    public int compareTo(ByteArrayWritable that) {
        return WritableComparator.compareBytes((byte[])this.data, (int)this.offset, (int)this.length, (byte[])that.data, (int)that.offset, (int)that.length);
    }

    public int compareToByteArray(byte[] that) {
        return WritableComparator.compareBytes((byte[])this.data, (int)this.offset, (int)this.length, (byte[])that, (int)0, (int)that.length);
    }

    public boolean equals(Object other) {
        if (other instanceof byte[]) {
            return this.compareToByteArray((byte[])other) == 0;
        }
        if (other instanceof ByteArrayWritable) {
            return this.compareTo((ByteArrayWritable)other) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(3 * this.length);
        int endIdx = this.offset + this.length;
        for (int idx = this.offset; idx < endIdx; ++idx) {
            sb.append(' ');
            String num = Integer.toHexString(0xFF & this.data[idx]);
            if (num.length() < 2) {
                sb.append('0');
            }
            sb.append(num);
        }
        return sb.length() > 0 ? sb.substring(1) : "";
    }

    static {
        WritableComparator.define(ByteArrayWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        private BytesWritable.Comparator instance = new BytesWritable.Comparator();

        public Comparator() {
            super(ByteArrayWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return this.instance.compare(b1, s1, l1, b2, s2, l2);
        }
    }
}

