/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.engine.mr.KylinReducer;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildGlobalHiveDictPartBuildReducer
extends KylinReducer<Text, LongWritable, LongWritable, Text> {
    private static final Logger logger = LoggerFactory.getLogger(BuildGlobalHiveDictPartBuildReducer.class);
    private Long count = 0L;
    private MultipleOutputs mos;
    private String[] dicCols;
    private String colName;
    private int colIndex;

    @Override
    protected void doSetup(Reducer.Context context) throws IOException, InterruptedException {
        KylinConfig config;
        this.mos = new MultipleOutputs((TaskInputOutputContext)context);
        try {
            config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.dicCols = config.getMrHiveDictColumnsExcludeRefColumns();
    }

    @Override
    public void doReduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Long l = this.count;
        Long l2 = this.count = Long.valueOf(this.count + 1L);
        byte[] keyBytes = Bytes.copy(key.getBytes(), 1, key.getLength() - 1);
        if (this.count == 1L) {
            this.colIndex = key.getBytes()[0];
            this.colName = this.dicCols[this.colIndex];
        }
        if (this.count < 10L) {
            logger.info("key:{}, temp dict num :{}, colIndex:{}, colName:{}", key.toString(), this.count, this.colIndex, this.colName);
        }
        this.mos.write(this.colIndex + "", (Object)new LongWritable(this.count.longValue()), (Object)new Text(keyBytes), "part_sort/" + this.colIndex);
    }

    @Override
    protected void doCleanup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String partition = conf.get("mapreduce.task.partition");
        this.mos.write(this.colIndex + "", (Object)new LongWritable(this.count.longValue()), (Object)new Text(partition), "reduce_stats/" + this.colIndex);
        this.mos.close();
        logger.info("Reduce partition num {} finish, this reduce done item count is {}", (Object)partition, (Object)this.count);
    }
}

