/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.MapReduceUtil;
import org.apache.kylin.engine.mr.steps.CalculateStatsFromBaseCuboidMapper;
import org.apache.kylin.engine.mr.steps.CalculateStatsFromBaseCuboidReducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateStatsFromBaseCuboidJob
extends AbstractHadoopJob {
    private static final Logger logger = LoggerFactory.getLogger(CalculateStatsFromBaseCuboidJob.class);

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_ID);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_STATISTICS_SAMPLING_PERCENT);
            options.addOption(OPTION_CUBOID_MODE);
            this.parseOptions(options, args);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME);
            String segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
            Path input = new Path(this.getOptionValue(OPTION_INPUT_PATH));
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            String statistics_sampling_percent = this.getOptionValue(OPTION_STATISTICS_SAMPLING_PERCENT);
            String cuboidMode = this.getOptionValue(OPTION_CUBOID_MODE);
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeSegment cubeSegment = cube.getSegmentById(segmentID);
            this.job.getConfiguration().set("cuboid.mode", cuboidMode);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentID);
            this.job.getConfiguration().set("statistics.sampling.percent", statistics_sampling_percent);
            this.job.getConfiguration().set("mapreduce.reduce.speculative", "false");
            logger.info("Starting: " + this.job.getJobName());
            this.setJobClasspath(this.job, cube.getConfig());
            this.setupMapper(input);
            this.setupReducer(output, cubeSegment);
            this.attachSegmentMetadataWithDict(cubeSegment, this.job.getConfiguration());
            int n = this.waitForCompletion(this.job);
            return n;
        }
        catch (Exception e) {
            logger.error("error in CalculateStatsFromBaseCuboidJob", e);
            this.printUsage(options);
            throw e;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private void setupMapper(Path input) throws IOException {
        FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{input});
        this.job.setMapperClass(CalculateStatsFromBaseCuboidMapper.class);
        this.job.setInputFormatClass(SequenceFileInputFormat.class);
        this.job.setMapOutputKeyClass(Text.class);
        this.job.setMapOutputValueClass(Text.class);
    }

    private void setupReducer(Path output, CubeSegment cubeSeg) throws IOException {
        int hllShardBase = MapReduceUtil.getCuboidHLLCounterReducerNum(cubeSeg.getCubeInstance());
        this.job.setReducerClass(CalculateStatsFromBaseCuboidReducer.class);
        this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
        this.job.setOutputKeyClass(NullWritable.class);
        this.job.setOutputValueClass(Text.class);
        this.job.setNumReduceTasks(hllShardBase);
        FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
        this.job.getConfiguration().set("output.path", output.toString());
        this.deletePath(this.job.getConfiguration(), output);
    }
}

