/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.io.Closeable;
import java.io.IOException;
import org.apache.kylin.gridtable.GTBuilder;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.IGTStore;

public class GridTable
implements Closeable {
    final GTInfo info;
    final IGTStore store;

    public GridTable(GTInfo info, IGTStore store) {
        this.info = info;
        this.store = store;
    }

    public GTBuilder rebuild() throws IOException {
        return this.rebuild(-1);
    }

    public GTBuilder rebuild(int shard) throws IOException {
        return new GTBuilder(this.info, shard, this.store);
    }

    public GTBuilder append() throws IOException {
        return this.append(-1);
    }

    public GTBuilder append(int shard) throws IOException {
        return new GTBuilder(this.info, shard, this.store, true);
    }

    public IGTScanner scan(GTScanRequest req) throws IOException {
        IGTScanner result = this.store.scan(req);
        return req.decorateScanner(result);
    }

    public GTInfo getInfo() {
        return this.info;
    }

    public IGTStore getStore() {
        return this.store;
    }

    @Override
    public void close() throws IOException {
        if (this.store instanceof Closeable) {
            ((Closeable)((Object)this.store)).close();
        }
    }
}

