/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.kafka.KafkaMsgProducer;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.exception.IllegalStateTranferException;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.BrokenExecutable;
import org.apache.kylin.job.execution.ChainedExecutable;
import org.apache.kylin.job.execution.CheckpointExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.DefaultOutput;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableManager {
    private static final Logger logger = LoggerFactory.getLogger(ExecutableManager.class);
    private final KylinConfig config;
    private final ExecutableDao executableDao;
    private KafkaMsgProducer kafkaMsgProducer;

    public static ExecutableManager getInstance(KylinConfig config) {
        return config.getManager(ExecutableManager.class);
    }

    static ExecutableManager newInstance(KylinConfig config) throws IOException {
        return new ExecutableManager(config);
    }

    private ExecutableManager(KylinConfig config) {
        logger.info("Using metadata url: " + config);
        this.config = config;
        this.executableDao = ExecutableDao.getInstance(config);
        if (config.jobStatusWriteKafka()) {
            this.kafkaMsgProducer = KafkaMsgProducer.getInstance();
        }
    }

    private static ExecutablePO parse(AbstractExecutable executable) {
        ExecutablePO result = new ExecutablePO();
        result.setName(executable.getName());
        result.setUuid(executable.getId());
        result.setType(executable.getClass().getName());
        result.setParams(executable.getParams());
        result.setPriority(executable.getPriority());
        if (executable instanceof ChainedExecutable) {
            ArrayList<ExecutablePO> tasks = Lists.newArrayList();
            for (AbstractExecutable abstractExecutable : ((ChainedExecutable)((Object)executable)).getTasks()) {
                tasks.add(ExecutableManager.parse(abstractExecutable));
            }
            result.setTasks(tasks);
        }
        if (executable instanceof CheckpointExecutable) {
            ArrayList<ExecutablePO> tasksForCheck = Lists.newArrayList();
            for (AbstractExecutable abstractExecutable : ((CheckpointExecutable)executable).getSubTasksForCheck()) {
                tasksForCheck.add(ExecutableManager.parse(abstractExecutable));
            }
            result.setTasksForCheck(tasksForCheck);
        }
        return result;
    }

    public void addJob(AbstractExecutable executable) {
        try {
            executable.initConfig(this.config);
            if (this.executableDao.getJob(executable.getId()) != null) {
                throw new IllegalArgumentException("job id:" + executable.getId() + " already exists");
            }
            this.addJobOutput(executable);
            this.executableDao.addJob(ExecutableManager.parse(executable));
        }
        catch (PersistentException e) {
            logger.error("fail to submit job:" + executable.getId(), e);
            throw new RuntimeException(e);
        }
    }

    private void addJobOutput(AbstractExecutable executable) throws PersistentException {
        ExecutableOutputPO executableOutputPO = new ExecutableOutputPO();
        executableOutputPO.setUuid(executable.getId());
        this.executableDao.addJobOutput(executableOutputPO);
        if (executable instanceof DefaultChainedExecutable) {
            for (AbstractExecutable subTask : ((DefaultChainedExecutable)executable).getTasks()) {
                this.addJobOutput(subTask);
            }
        }
    }

    public void updateCheckpointJob(String jobId, List<AbstractExecutable> subTasksForCheck) {
        try {
            jobId = jobId.replaceAll("[./]", "");
            ExecutablePO job = this.executableDao.getJob(jobId);
            Preconditions.checkArgument(job != null, "there is no related job for job id:" + jobId);
            ArrayList<ExecutablePO> tasksForCheck = Lists.newArrayListWithExpectedSize(subTasksForCheck.size());
            for (AbstractExecutable taskForCheck : subTasksForCheck) {
                tasksForCheck.add(ExecutableManager.parse(taskForCheck));
            }
            job.setTasksForCheck(tasksForCheck);
            this.executableDao.updateJob(job);
        }
        catch (PersistentException e) {
            logger.error("fail to update checkpoint job:" + jobId, e);
            throw new RuntimeException(e);
        }
    }

    public void deleteJob(String jobId) {
        try {
            jobId = jobId.replaceAll("[./]", "");
            this.executableDao.deleteJob(jobId);
        }
        catch (PersistentException e) {
            logger.error("fail to delete job:" + jobId, e);
            throw new RuntimeException(e);
        }
    }

    public AbstractExecutable getJob(String uuid) {
        try {
            uuid = uuid.replaceAll("[./]", "");
            return this.parseTo(this.executableDao.getJob(uuid));
        }
        catch (PersistentException e) {
            logger.error("fail to get job:" + uuid, e);
            throw new RuntimeException(e);
        }
    }

    public AbstractExecutable getJobDigest(String uuid) {
        return this.parseTo(this.executableDao.getJobDigest(uuid));
    }

    public void syncDigestsOfJob(String uuid) throws PersistentException {
        this.executableDao.syncDigestsOfJob(uuid);
    }

    public Output getOutput(String uuid) {
        try {
            uuid = uuid.replaceAll("[./]", "");
            ExecutableOutputPO jobOutput = this.executableDao.getJobOutput(uuid);
            Preconditions.checkArgument(jobOutput != null, "there is no related output for job id:" + uuid);
            return this.parseOutput(jobOutput);
        }
        catch (PersistentException e) {
            logger.error("fail to get job output:" + uuid, e);
            throw new RuntimeException(e);
        }
    }

    public Output getOutputDigest(String uuid) {
        ExecutableOutputPO jobOutput = this.executableDao.getJobOutputDigest(uuid);
        Preconditions.checkArgument(jobOutput != null, "there is no related output for job id:" + uuid);
        return this.parseOutput(jobOutput);
    }

    private DefaultOutput parseOutput(ExecutableOutputPO jobOutput) {
        DefaultOutput result = new DefaultOutput();
        result.setExtra(jobOutput.getInfo());
        result.setState(ExecutableState.valueOf(jobOutput.getStatus()));
        result.setVerboseMsg(jobOutput.getContent());
        result.setLastModified(jobOutput.getLastModified());
        return result;
    }

    public Map<String, Output> getAllOutputs() {
        try {
            List<ExecutableOutputPO> jobOutputs = this.executableDao.getJobOutputs();
            HashMap<String, Output> result = Maps.newHashMap();
            for (ExecutableOutputPO jobOutput : jobOutputs) {
                result.put(jobOutput.getId(), this.parseOutput(jobOutput));
            }
            return result;
        }
        catch (PersistentException e) {
            logger.error("fail to get all job output:", e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, Output> getAllOutputs(long timeStartInMillis, long timeEndInMillis) {
        try {
            List<ExecutableOutputPO> jobOutputs = this.executableDao.getJobOutputs(timeStartInMillis, timeEndInMillis);
            HashMap<String, Output> result = Maps.newHashMap();
            for (ExecutableOutputPO jobOutput : jobOutputs) {
                result.put(jobOutput.getId(), this.parseOutput(jobOutput));
            }
            return result;
        }
        catch (PersistentException e) {
            logger.error("fail to get all job output:", e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, ExecutableOutputPO> getAllOutputDigests(long timeStartInMillis, long timeEndInMillis) {
        List<ExecutableOutputPO> jobOutputs = this.executableDao.getJobOutputDigests(timeStartInMillis, timeEndInMillis);
        HashMap<String, ExecutableOutputPO> result = Maps.newHashMap();
        for (ExecutableOutputPO jobOutput : jobOutputs) {
            result.put(jobOutput.getId(), jobOutput);
        }
        return result;
    }

    public List<AbstractExecutable> getAllExecutables() {
        try {
            ArrayList<AbstractExecutable> ret = Lists.newArrayList();
            for (ExecutablePO po : this.executableDao.getJobs()) {
                try {
                    AbstractExecutable ae = this.parseTo(po);
                    ret.add(ae);
                }
                catch (IllegalArgumentException e) {
                    logger.error("error parsing one executabePO: ", e);
                }
            }
            return ret;
        }
        catch (PersistentException e) {
            logger.error("error get All Jobs", e);
            throw new RuntimeException(e);
        }
    }

    public List<AbstractExecutable> getAllExecutables(long timeStartInMillis, long timeEndInMillis) {
        try {
            ArrayList<AbstractExecutable> ret = Lists.newArrayList();
            for (ExecutablePO po : this.executableDao.getJobs(timeStartInMillis, timeEndInMillis)) {
                try {
                    AbstractExecutable ae = this.parseTo(po);
                    ret.add(ae);
                }
                catch (IllegalArgumentException e) {
                    logger.error("error parsing one executabePO: ", e);
                }
            }
            return ret;
        }
        catch (PersistentException e) {
            logger.error("error get All Jobs", e);
            throw new RuntimeException(e);
        }
    }

    public List<AbstractExecutable> getAllExecutableDigests(long timeStartInMillis, long timeEndInMillis) {
        ArrayList<AbstractExecutable> ret = Lists.newArrayList();
        for (ExecutablePO po : this.executableDao.getJobDigests(timeStartInMillis, timeEndInMillis)) {
            try {
                AbstractExecutable ae = this.parseTo(po);
                ret.add(ae);
            }
            catch (IllegalArgumentException e) {
                logger.error("error parsing one executabePO: ", e);
            }
        }
        return ret;
    }

    public List<String> getAllJobIds() {
        try {
            return this.executableDao.getJobIds();
        }
        catch (PersistentException e) {
            logger.error("error get All Job Ids", e);
            throw new RuntimeException(e);
        }
    }

    public void updateAllRunningJobsToError() {
        try {
            List<ExecutableOutputPO> jobOutputs = this.executableDao.getJobOutputs();
            for (ExecutableOutputPO executableOutputPO : jobOutputs) {
                if (!executableOutputPO.getStatus().equalsIgnoreCase(ExecutableState.RUNNING.toString())) continue;
                executableOutputPO.setStatus(ExecutableState.ERROR.toString());
                this.executableDao.updateJobOutput(executableOutputPO);
            }
        }
        catch (PersistentException e) {
            logger.error("error reset job status from RUNNING to ERROR", e);
            throw new RuntimeException(e);
        }
    }

    public List<String> getAllJobIdsInCache() {
        return this.executableDao.getJobIdsInCache();
    }

    public void resumeAllRunningJobs() {
        try {
            List<ExecutableOutputPO> jobOutputs = this.executableDao.getJobOutputs();
            for (ExecutableOutputPO executableOutputPO : jobOutputs) {
                if (!executableOutputPO.getStatus().equalsIgnoreCase(ExecutableState.RUNNING.toString())) continue;
                executableOutputPO.setStatus(ExecutableState.READY.toString());
                this.executableDao.updateJobOutput(executableOutputPO);
            }
        }
        catch (PersistentException e) {
            logger.error("error reset job status from RUNNING to READY", e);
            throw new RuntimeException(e);
        }
    }

    public void resumeRunningJobForce(String jobId) {
        AbstractExecutable job = this.getJob(jobId);
        if (job == null) {
            return;
        }
        if (job instanceof DefaultChainedExecutable) {
            List<AbstractExecutable> tasks = ((DefaultChainedExecutable)job).getTasks();
            for (AbstractExecutable task : tasks) {
                if (task.getStatus() != ExecutableState.RUNNING) continue;
                this.updateJobOutput(task.getId(), ExecutableState.READY, null, null);
                break;
            }
        }
        this.updateJobOutput(jobId, ExecutableState.READY, null, null);
    }

    public void resumeJob(String jobId) {
        AbstractExecutable job = this.getJob(jobId);
        if (job == null) {
            return;
        }
        HashMap<String, String> info = null;
        if (job instanceof DefaultChainedExecutable) {
            long endTime;
            List<AbstractExecutable> tasks = ((DefaultChainedExecutable)job).getTasks();
            for (AbstractExecutable task : tasks) {
                if (task.getStatus() != ExecutableState.ERROR && task.getStatus() != ExecutableState.STOPPED) continue;
                this.updateJobOutput(task.getId(), ExecutableState.READY, null, "no output");
                break;
            }
            if ((endTime = job.getEndTime()) != 0L) {
                long interruptTime = System.currentTimeMillis() - endTime + job.getInterruptTime();
                info = Maps.newHashMap(this.getJobOutput(jobId).getInfo());
                info.put("interruptTime", Long.toString(interruptTime));
                info.remove("endTime");
            }
        }
        this.updateJobOutput(jobId, ExecutableState.READY, info, null);
    }

    public void discardJob(String jobId) {
        AbstractExecutable job = this.getJob(jobId);
        if (job == null) {
            return;
        }
        if (job.getStatus().isFinalState()) {
            if (job.getStatus() != ExecutableState.DISCARDED) {
                logger.warn("The status of job " + jobId + " is " + job.getStatus().toString() + ". It's final state and cannot be transfer to be discarded!!!");
            } else {
                logger.warn("The job " + jobId + " has been discarded.");
            }
            throw new IllegalStateException("The job " + job.getId() + " has already been finished and cannot be discarded.");
        }
        if (job instanceof DefaultChainedExecutable) {
            List<AbstractExecutable> tasks = ((DefaultChainedExecutable)job).getTasks();
            for (AbstractExecutable task : tasks) {
                if (task.getStatus().isFinalState()) continue;
                this.updateJobOutput(task.getId(), ExecutableState.DISCARDED, null, null);
            }
        }
        this.updateJobOutput(jobId, ExecutableState.DISCARDED, null, null);
    }

    public void rollbackJob(String jobId, String stepId) {
        AbstractExecutable job = this.getJob(jobId);
        if (job == null) {
            return;
        }
        if (job instanceof DefaultChainedExecutable) {
            List<AbstractExecutable> tasks = ((DefaultChainedExecutable)job).getTasks();
            for (AbstractExecutable task : tasks) {
                if (task.getId().compareTo(stepId) < 0) continue;
                logger.debug("rollback task : " + task);
                this.updateJobOutput(task.getId(), ExecutableState.READY, Maps.newHashMap(), "");
            }
        }
        if (job.getStatus() == ExecutableState.SUCCEED) {
            this.updateJobOutput(job.getId(), ExecutableState.READY, null, null);
        }
    }

    public void pauseJob(String jobId) {
        AbstractExecutable job = this.getJob(jobId);
        if (job == null) {
            return;
        }
        if (job.getStatus() != ExecutableState.READY && job.getStatus() != ExecutableState.RUNNING) {
            logger.warn("The status of job " + jobId + " is " + job.getStatus().toString() + ". It's final state and cannot be transfer to be stopped!!!");
            throw new IllegalStateException("The job " + job.getId() + " has already been finished and cannot be stopped.");
        }
        if (job instanceof DefaultChainedExecutable) {
            List<AbstractExecutable> tasks = ((DefaultChainedExecutable)job).getTasks();
            for (AbstractExecutable task : tasks) {
                if (task.getStatus().isFinalState()) continue;
                this.updateJobOutput(task.getId(), ExecutableState.STOPPED, null, null);
                break;
            }
        }
        this.updateJobOutput(jobId, ExecutableState.STOPPED, null, null);
    }

    public ExecutableOutputPO getJobOutput(String jobId) {
        try {
            return this.executableDao.getJobOutput(jobId);
        }
        catch (PersistentException e) {
            logger.error("Can't get output of Job " + jobId);
            throw new RuntimeException(e);
        }
    }

    public void updateJobOutput(String jobId, ExecutableState newStatus, Map<String, String> info, String output) {
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("Current thread is interruptted, aborting");
        }
        try {
            ExecutableOutputPO jobOutput = this.executableDao.getJobOutput(jobId);
            Preconditions.checkArgument(jobOutput != null, "there is no related output for job id:" + jobId);
            ExecutableState oldStatus = ExecutableState.valueOf(jobOutput.getStatus());
            if (newStatus != null && oldStatus != newStatus) {
                if (!ExecutableState.isValidStateTransfer(oldStatus, newStatus)) {
                    throw new IllegalStateTranferException("there is no valid state transfer from:" + (Object)((Object)oldStatus) + " to:" + (Object)((Object)newStatus) + ", job id: " + jobId);
                }
                jobOutput.setStatus(newStatus.toString());
            }
            if (info != null) {
                jobOutput.setInfo(info);
            }
            if (output != null) {
                if (output.length() > this.config.getJobOutputMaxSize()) {
                    output = output.substring(0, this.config.getJobOutputMaxSize());
                }
                jobOutput.setContent(output);
            }
            this.executableDao.updateJobOutput(jobOutput);
            logger.info("job id:" + jobId + " from " + (Object)((Object)oldStatus) + " to " + (Object)((Object)newStatus));
            if (this.config.jobStatusWriteKafka()) {
                AbstractExecutable executable = this.getJob(jobId);
                if (executable == null) {
                    return;
                }
                if (executable instanceof DefaultChainedExecutable) {
                    StringBuffer result = new StringBuffer();
                    DefaultChainedExecutable job = (DefaultChainedExecutable)executable;
                    result.append("{");
                    result.append("\"jobId\":\"" + job.getId() + "\",");
                    result.append("\"jobName\":\"" + job.getName() + "\",");
                    result.append("\"status\":\"" + this.parseToJobStatus(job.getStatus()).name() + "\",");
                    result.append("\"subTaskSize\": \"" + job.getTasks().size() + "\",");
                    result.append("\"subTasks\":[");
                    job.getTasks().forEach(item -> {
                        result.append("{");
                        result.append("\"jobId\":\"" + item.getId() + "\",");
                        result.append("\"jobName\":\"" + item.getName() + "\",");
                        result.append("\"status\":\"" + this.parseToJobStatus(item.getStatus()).name() + "\"");
                        result.append("},");
                    });
                    String resultStr = result.substring(0, result.length() - 1);
                    resultStr = resultStr + "]}";
                    this.kafkaMsgProducer.sendJobStatusMessage(resultStr);
                }
            }
        }
        catch (PersistentException e) {
            logger.error("error change job:" + jobId + " to " + (Object)((Object)newStatus));
            throw new RuntimeException(e);
        }
    }

    private JobStatusEnum parseToJobStatus(ExecutableState state) {
        switch (state) {
            case READY: {
                return JobStatusEnum.PENDING;
            }
            case RUNNING: {
                return JobStatusEnum.RUNNING;
            }
            case ERROR: {
                return JobStatusEnum.ERROR;
            }
            case DISCARDED: {
                return JobStatusEnum.DISCARDED;
            }
            case SUCCEED: {
                return JobStatusEnum.FINISHED;
            }
            case STOPPED: {
                return JobStatusEnum.STOPPED;
            }
        }
        throw new RuntimeException("invalid state:" + (Object)((Object)state));
    }

    public void reloadAll() throws IOException {
        this.executableDao.reloadAll();
    }

    public void forceKillJob(String jobId) {
        try {
            ExecutableOutputPO jobOutput = this.executableDao.getJobOutput(jobId);
            List<ExecutablePO> tasks = this.executableDao.getJob(jobId).getTasks();
            for (ExecutablePO task : tasks) {
                if (this.executableDao.getJobOutput(task.getId()).getStatus().equals("SUCCEED")) continue;
                if (!this.executableDao.getJobOutput(task.getId()).getStatus().equals("RUNNING")) break;
                this.updateJobOutput(task.getId(), ExecutableState.READY, Maps.newHashMap(), "");
                break;
            }
            if (!jobOutput.getStatus().equals(ExecutableState.ERROR.toString())) {
                jobOutput.setStatus(ExecutableState.ERROR.toString());
                this.executableDao.updateJobOutput(jobOutput);
            }
        }
        catch (PersistentException e) {
            throw new RuntimeException(e);
        }
    }

    public void forceKillJobWithRetry(String jobId) {
        boolean done = false;
        while (!done) {
            try {
                this.forceKillJob(jobId);
                done = true;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof PersistentException) continue;
                done = true;
            }
        }
    }

    public void resetJobOutput(String jobId, ExecutableState state, String output) {
        try {
            ExecutableOutputPO jobOutput = this.executableDao.getJobOutput(jobId);
            jobOutput.setStatus(state.toString());
            if (output != null) {
                jobOutput.setContent(output);
            }
            this.executableDao.updateJobOutput(jobOutput);
        }
        catch (PersistentException e) {
            throw new RuntimeException(e);
        }
    }

    public void addJobInfo(String id, Map<String, String> info) {
        String jobId;
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("Current thread is interrupted, aborting");
        }
        if (info == null) {
            return;
        }
        if (info.containsKey("mr_job_id") && !info.containsKey("yarn_application_id") && (jobId = info.get("mr_job_id")).startsWith("job_")) {
            info.put("yarn_application_id", jobId.replace("job_", "application_"));
        }
        if ((info.containsKey("yarn_application_id") || info.containsKey("flink_job_id")) && !StringUtils.isEmpty(this.config.getJobTrackingURLPattern())) {
            String pattern = this.config.getJobTrackingURLPattern();
            String jobId2 = info.containsKey("yarn_application_id") ? info.get("yarn_application_id") : info.get("flink_job_id");
            try {
                String newTrackingURL = String.format(Locale.ROOT, pattern, jobId2);
                info.put("yarn_application_tracking_url", newTrackingURL);
            }
            catch (IllegalFormatException ife) {
                logger.error("Illegal tracking url pattern: " + this.config.getJobTrackingURLPattern());
            }
        }
        try {
            ExecutableOutputPO output = this.executableDao.getJobOutput(id);
            Preconditions.checkArgument(output != null, "there is no related output for job id:" + id);
            output.getInfo().putAll(info);
            this.executableDao.updateJobOutput(output);
        }
        catch (PersistentException e) {
            logger.error("error update job info, id:" + id + "  info:" + info.toString());
            throw new RuntimeException(e);
        }
    }

    public void addJobInfo(String id, String key, String value) {
        HashMap<String, String> info = Maps.newHashMap();
        info.put(key, value);
        this.addJobInfo(id, info);
    }

    private AbstractExecutable parseTo(ExecutablePO executablePO) {
        if (executablePO == null) {
            logger.warn("executablePO is null");
            return null;
        }
        String type = executablePO.getType();
        AbstractExecutable result = this.newExecutable(type);
        result.initConfig(this.config);
        result.setId(executablePO.getUuid());
        result.setName(executablePO.getName());
        result.setParams(executablePO.getParams());
        result.setPriority(executablePO.getPriority());
        if (!(result instanceof BrokenExecutable)) {
            List<ExecutablePO> tasksForCheck;
            List<ExecutablePO> tasks = executablePO.getTasks();
            if (tasks != null && !tasks.isEmpty()) {
                Preconditions.checkArgument(result instanceof ChainedExecutable);
                for (ExecutablePO subTask : tasks) {
                    AbstractExecutable subTaskExecutable = this.parseTo(subTask);
                    if (subTaskExecutable != null) {
                        subTaskExecutable.setParentExecutable(result);
                    }
                    ((ChainedExecutable)((Object)result)).addTask(this.parseTo(subTask));
                }
            }
            if ((tasksForCheck = executablePO.getTasksForCheck()) != null && !tasksForCheck.isEmpty()) {
                Preconditions.checkArgument(result instanceof CheckpointExecutable);
                for (ExecutablePO subTaskForCheck : tasksForCheck) {
                    ((CheckpointExecutable)result).addTaskForCheck(this.parseTo(subTaskForCheck));
                }
            }
        }
        return result;
    }

    private AbstractExecutable newExecutable(String type) {
        Class<AbstractExecutable> clazz;
        try {
            clazz = ClassUtil.forName(type, AbstractExecutable.class);
        }
        catch (ClassNotFoundException ex) {
            clazz = BrokenExecutable.class;
            logger.error("Unknown executable type '" + type + "', using BrokenExecutable");
        }
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + clazz, e);
        }
    }
}

