/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.expression;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kylin.exception.QueryOnCubeException;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.expression.ExpressionColCollector;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class BinaryTupleExpression
extends TupleExpression {
    public BinaryTupleExpression(DataType dataType, TupleExpression.ExpressionOperatorEnum op) {
        this(dataType, op, Lists.newArrayListWithExpectedSize(2));
    }

    public BinaryTupleExpression(TupleExpression.ExpressionOperatorEnum op, TupleExpression left, TupleExpression right) {
        this(BinaryTupleExpression.referDataType(op, left, right), op, Lists.newArrayList(left, right));
    }

    public BinaryTupleExpression(DataType dataType, TupleExpression.ExpressionOperatorEnum op, List<TupleExpression> exprs) {
        super(dataType, op, exprs);
        BinaryTupleExpression.checkBinaryOp(op, exprs);
    }

    @Override
    public void addChild(TupleExpression child) {
        assert (child.getDataType().isNumberFamily());
        super.addChild(child);
    }

    @Override
    public boolean ifForDynamicColumn() {
        return this.ifAbleToPushDown();
    }

    @Override
    public void verify() {
        switch (this.operator) {
            case MULTIPLE: {
                this.verifyMultiply();
                break;
            }
            case DIVIDE: {
                this.verifyDivide();
                break;
            }
        }
    }

    private void verifyMultiply() {
        if (ExpressionColCollector.collectMeasureColumns(this.getLeft()).size() > 0 && ExpressionColCollector.collectMeasureColumns(this.getRight()).size() > 0) {
            throw new QueryOnCubeException("That both of the two sides of the BinaryTupleExpression own columns is not supported for " + this.operator.toString());
        }
    }

    private void verifyDivide() {
        if (ExpressionColCollector.collectMeasureColumns(this.getRight()).size() > 0) {
            throw new QueryOnCubeException("That the right side of the BinaryTupleExpression owns columns is not supported for " + this.operator.toString());
        }
    }

    @Override
    public Object calculate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        Object left = this.referValue(this.getLeft().calculate(tuple, cs));
        if (left == null) {
            return null;
        }
        Object right = this.referValue(this.getRight().calculate(tuple, cs));
        if (right == null) {
            return null;
        }
        if (this.dataType.isDecimal()) {
            BigDecimal leftV = (BigDecimal)left;
            BigDecimal rightV = (BigDecimal)right;
            switch (this.operator) {
                case PLUS: {
                    return leftV.add(rightV);
                }
                case MINUS: {
                    return leftV.subtract(rightV);
                }
                case MULTIPLE: {
                    return leftV.multiply(rightV);
                }
                case DIVIDE: {
                    return leftV.divide(rightV);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (this.dataType.isIntegerFamily()) {
            long leftV = (Long)left;
            long rightV = (Long)right;
            switch (this.operator) {
                case PLUS: {
                    return leftV + rightV;
                }
                case MINUS: {
                    return leftV - rightV;
                }
                case MULTIPLE: {
                    return leftV * rightV;
                }
                case DIVIDE: {
                    return leftV / rightV;
                }
            }
            throw new UnsupportedOperationException();
        }
        double leftV = (Double)left;
        double rightV = (Double)right;
        switch (this.operator) {
            case PLUS: {
                return leftV + rightV;
            }
            case MINUS: {
                return leftV - rightV;
            }
            case MULTIPLE: {
                return leftV * rightV;
            }
            case DIVIDE: {
                return leftV / rightV;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public TupleExpression accept(ExpressionVisitor visitor) {
        return visitor.visitBinary(this);
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }

    public TupleExpression getLeft() {
        return (TupleExpression)this.children.get(0);
    }

    public TupleExpression getRight() {
        return (TupleExpression)this.children.get(1);
    }

    public String toString() {
        return this.operator.toString() + "(" + this.getLeft().toString() + "," + this.getRight().toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryTupleExpression that = (BinaryTupleExpression)o;
        if (this.operator != that.operator) {
            return false;
        }
        return this.children.equals(that.children);
    }

    public int hashCode() {
        int result = this.operator != null ? this.operator.hashCode() : 0;
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }

    private static void checkBinaryOp(TupleExpression.ExpressionOperatorEnum op, List<TupleExpression> exprs) {
        boolean opGood;
        boolean bl = opGood = op == TupleExpression.ExpressionOperatorEnum.PLUS || op == TupleExpression.ExpressionOperatorEnum.MINUS || op == TupleExpression.ExpressionOperatorEnum.MULTIPLE || op == TupleExpression.ExpressionOperatorEnum.DIVIDE;
        if (!opGood) {
            throw new IllegalArgumentException("Unsupported operator " + (Object)((Object)op));
        }
    }

    public static DataType referDataType(TupleExpression.ExpressionOperatorEnum op, TupleExpression left, TupleExpression right) {
        BinaryTupleExpression.checkBinaryOp(op, Lists.newArrayList(left, right));
        DataType dataType = TupleExpression.referDataType(left.getDataType(), right.getDataType());
        if (op == TupleExpression.ExpressionOperatorEnum.DIVIDE && dataType.isIntegerFamily()) {
            dataType = DataType.getType("double");
        }
        return dataType;
    }
}

