/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.exception.QueryOnCubeException;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.metadata.realization.RoutingIndicatorException;
import org.apache.kylin.query.adhoc.PushDownRunnerJdbcImpl;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.kylin.source.adhocquery.IPushDownRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushDownExecutor {
    private final Logger logger = LoggerFactory.getLogger(PushDownExecutor.class);
    private KylinConfig kylinConfig;

    public PushDownExecutor(KylinConfig config) {
        this.kylinConfig = config == null ? KylinConfig.getInstanceFromEnv() : config;
    }

    public Pair<List<List<String>>, List<SelectedColumnMeta>> pushDownQuery(String project, String sql, String defaultSchema, SQLException sqlException, boolean isSelect, boolean isPrepare) throws Exception {
        List<String> ids;
        if (!this.kylinConfig.isPushDownEnabled()) {
            return null;
        }
        if (isSelect) {
            this.logger.info("Query failed to utilize pre-calculation, routing to other engines", sqlException);
            if (!PushDownExecutor.isExpectedCause(sqlException)) {
                this.logger.info("quit doPushDownQuery because prior exception thrown is unexpected");
                return null;
            }
        } else {
            Preconditions.checkState(sqlException == null);
            this.logger.info("Kylin cannot support non-select queries, routing to other engines");
        }
        if ((ids = this.kylinConfig.getPushDownRunnerIds()).isEmpty() && StringUtils.isNotEmpty((String)this.kylinConfig.getPushDownRunnerClassName())) {
            IPushDownRunner runner = (IPushDownRunner)ClassUtil.newInstance(this.kylinConfig.getPushDownRunnerClassName());
            runner.init(this.kylinConfig);
            return this.queryBySingleRunner(runner, project, sql, defaultSchema, sqlException, isSelect, isPrepare);
        }
        return this.queryByMultiJdbcRunners(ids, project, sql, defaultSchema, sqlException, isSelect, isPrepare);
    }

    private static boolean isExpectedCause(SQLException sqlException) {
        Preconditions.checkArgument(sqlException != null);
        Throwable rootCause = ExceptionUtils.getRootCause(sqlException);
        boolean isPushDownUpdateEnabled = KylinConfig.getInstanceFromEnv().isPushDownUpdateEnabled();
        if (!isPushDownUpdateEnabled) {
            return rootCause != null && (rootCause instanceof NoRealizationFoundException || rootCause instanceof RoutingIndicatorException || rootCause instanceof QueryOnCubeException);
        }
        return rootCause != null && (rootCause instanceof NoRealizationFoundException || rootCause instanceof SqlValidatorException || rootCause instanceof RoutingIndicatorException || rootCause instanceof QueryOnCubeException);
    }

    private Pair<List<List<String>>, List<SelectedColumnMeta>> queryBySingleRunner(IPushDownRunner runner, String project, String sql, String defaultSchema, SQLException sqlException, boolean isSelect, boolean isPrepare) throws Exception {
        this.logger.debug("Query Pushdown runner {}", (Object)runner);
        if (defaultSchema != null && !defaultSchema.equals("DEFAULT")) {
            String completed = sql;
            try {
                completed = PushDownUtil.schemaCompletion(sql, defaultSchema);
            }
            catch (SqlParseException e) {
                this.logger.debug("fail to do schema completion on the pushdown sql, ignore it.", (Object)e.getMessage());
            }
            if (!sql.equals(completed)) {
                this.logger.info("the query is converted to {} after schema completion", (Object)completed);
                sql = completed;
            }
        }
        sql = runner.convertSql(this.kylinConfig, sql, project, defaultSchema, isPrepare);
        ArrayList<List<String>> returnRows = Lists.newArrayList();
        ArrayList<SelectedColumnMeta> returnColumnMeta = Lists.newArrayList();
        if (isSelect) {
            runner.executeQuery(sql, returnRows, returnColumnMeta);
        }
        if (!isSelect && !isPrepare && this.kylinConfig.isPushDownUpdateEnabled()) {
            runner.executeUpdate(sql);
        }
        return Pair.newPair(returnRows, returnColumnMeta);
    }

    private Pair<List<List<String>>, List<SelectedColumnMeta>> queryByMultiJdbcRunners(List<String> ids, String project, String sql, String defaultSchema, SQLException sqlException, boolean isSelect, boolean isPrepare) throws Exception {
        for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i);
            PushDownRunnerJdbcImpl runner = new PushDownRunnerJdbcImpl();
            runner.initById(this.kylinConfig, id);
            try {
                Pair<List<List<String>>, List<SelectedColumnMeta>> ret = this.queryBySingleRunner(runner, project, sql, defaultSchema, sqlException, isSelect, isPrepare);
                if (null == ret) continue;
                return ret;
            }
            catch (Exception e) {
                this.logger.error("Execute pushdown query/update by jdbc runner " + id + " failed: " + ExceptionUtils.getStackTrace(e));
            }
        }
        throw new RuntimeException("Execute pushdown query/update by multi jdbc runners failed");
    }
}

