/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.source.ISampleDataDeployer;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.hive.HiveClientFactory;
import org.apache.kylin.source.hive.HiveTableMeta;
import org.apache.kylin.source.hive.IHiveClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetadataExplorer
implements ISourceMetadataExplorer,
ISampleDataDeployer {
    private static final Logger logger = LoggerFactory.getLogger(HiveClientFactory.class);
    IHiveClient hiveClient = HiveClientFactory.getHiveClient();

    @Override
    public List<String> listDatabases() throws Exception {
        return this.hiveClient.getHiveDbNames();
    }

    @Override
    public List<String> listTables(String database) throws Exception {
        return this.hiveClient.getHiveTableNames(database);
    }

    @Override
    public Pair<TableDesc, TableExtDesc> loadTableMetadata(String database, String tableName, String prj) {
        HiveTableMeta hiveTableMeta;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        TableMetadataManager metaMgr = TableMetadataManager.getInstance(config);
        try {
            hiveTableMeta = this.hiveClient.getHiveTableMeta(database, tableName);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot get HiveTableMeta", e);
        }
        TableDesc tableDesc = metaMgr.getTableDesc(database + "." + tableName, prj);
        if (tableDesc == null) {
            tableDesc = new TableDesc();
            tableDesc.setDatabase(database.toUpperCase(Locale.ROOT));
            tableDesc.setName(tableName.toUpperCase(Locale.ROOT));
            tableDesc.setUuid(RandomUtil.randomUUID().toString());
            tableDesc.setLastModified(0L);
        } else {
            tableDesc = new TableDesc(tableDesc);
        }
        if (hiveTableMeta.tableType != null) {
            tableDesc.setTableType(hiveTableMeta.tableType);
        }
        tableDesc.setColumns(this.extractColumnFromMeta(hiveTableMeta));
        StringBuffer partitionColumnString = new StringBuffer();
        int n = hiveTableMeta.partitionColumns.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                partitionColumnString.append(", ");
            }
            partitionColumnString.append(hiveTableMeta.partitionColumns.get((int)i).name.toUpperCase(Locale.ROOT));
        }
        TableExtDesc tableExtDesc = new TableExtDesc();
        tableExtDesc.setIdentity(tableDesc.getIdentity());
        tableExtDesc.setUuid(RandomUtil.randomUUID().toString());
        tableExtDesc.setLastModified(0L);
        tableExtDesc.init(prj);
        tableExtDesc.addDataSourceProp("location", hiveTableMeta.sdLocation);
        tableExtDesc.addDataSourceProp("owner", hiveTableMeta.owner);
        tableExtDesc.addDataSourceProp("last_access_time", String.valueOf(hiveTableMeta.lastAccessTime));
        tableExtDesc.addDataSourceProp("partition_column", partitionColumnString.toString());
        tableExtDesc.addDataSourceProp("total_file_size", String.valueOf(hiveTableMeta.fileSize));
        tableExtDesc.addDataSourceProp("total_file_number", String.valueOf(hiveTableMeta.fileNum));
        tableExtDesc.addDataSourceProp("hive_inputFormat", hiveTableMeta.sdInputFormat);
        tableExtDesc.addDataSourceProp("hive_outputFormat", hiveTableMeta.sdOutputFormat);
        tableExtDesc.addDataSourceProp("skip_header_line_count", String.valueOf(hiveTableMeta.skipHeaderLineCount));
        return Pair.newPair(tableDesc, tableExtDesc);
    }

    @Override
    public List<String> getRelatedKylinResources(TableDesc table) {
        return Collections.emptyList();
    }

    @Override
    public void createSampleDatabase(String database) throws Exception {
        this.hiveClient.executeHQL(this.generateCreateSchemaSql(database));
    }

    private String generateCreateSchemaSql(String schemaName) {
        return String.format(Locale.ROOT, "CREATE DATABASE IF NOT EXISTS %s", schemaName);
    }

    @Override
    public void createSampleTable(TableDesc table) throws Exception {
        this.hiveClient.executeHQL(this.generateCreateTableSql(table));
    }

    private String[] generateCreateTableSql(TableDesc tableDesc) {
        String dropsql = "DROP TABLE IF EXISTS " + tableDesc.getIdentity();
        String dropsql2 = "DROP VIEW IF EXISTS " + tableDesc.getIdentity();
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE TABLE " + tableDesc.getIdentity() + "\n");
        ddl.append("(\n");
        for (int i = 0; i < tableDesc.getColumns().length; ++i) {
            ColumnDesc col = tableDesc.getColumns()[i];
            if (i > 0) {
                ddl.append(",");
            }
            ddl.append(col.getName() + " " + HiveMetadataExplorer.getHiveDataType(col.getDatatype()) + "\n");
        }
        ddl.append(")\n");
        ddl.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY ','\n");
        ddl.append("STORED AS TEXTFILE");
        return new String[]{dropsql, dropsql2, ddl.toString()};
    }

    @Override
    public void loadSampleData(String tableName, String tmpDataDir) throws Exception {
        this.hiveClient.executeHQL(this.generateLoadDataSql(tableName, tmpDataDir));
    }

    private String generateLoadDataSql(String tableName, String tableFileDir) {
        return "LOAD DATA LOCAL INPATH '" + tableFileDir + "/" + tableName + ".csv' OVERWRITE INTO TABLE " + tableName;
    }

    @Override
    public void createWrapperView(String origTableName, String viewName) throws Exception {
        this.hiveClient.executeHQL(this.generateCreateViewSql(viewName, origTableName));
    }

    private String[] generateCreateViewSql(String viewName, String tableName) {
        String dropView = "DROP VIEW IF EXISTS " + viewName;
        String dropTable = "DROP TABLE IF EXISTS " + viewName;
        String createSql = "CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName;
        return new String[]{dropView, dropTable, createSql};
    }

    private static String getHiveDataType(String javaDataType) {
        String hiveDataType = javaDataType.toLowerCase(Locale.ROOT).startsWith("varchar") ? "string" : javaDataType;
        hiveDataType = javaDataType.toLowerCase(Locale.ROOT).startsWith("integer") ? "int" : hiveDataType;
        return hiveDataType.toLowerCase(Locale.ROOT);
    }

    @Override
    public ColumnDesc[] evalQueryMetadata(String query) {
        if (StringUtils.isEmpty(query)) {
            throw new RuntimeException("Evaluate query shall not be empty.");
        }
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String tmpDatabase = config.getHiveDatabaseForIntermediateTable();
        String tmpView = "kylin_eval_query_" + UUID.nameUUIDFromBytes(query.getBytes(StandardCharsets.UTF_8)).toString().replace("-", "");
        String dropViewSql = "DROP VIEW IF EXISTS " + tmpDatabase + "." + tmpView;
        String evalViewSql = "CREATE VIEW " + tmpDatabase + "." + tmpView + " as " + query;
        try {
            logger.debug("Removing duplicate view {}", (Object)tmpView);
            this.hiveClient.executeHQL(dropViewSql);
            logger.debug("Creating view {} for query: {}", (Object)tmpView, (Object)query);
            this.hiveClient.executeHQL(evalViewSql);
            logger.debug("Evaluating query columns' metadata");
            HiveTableMeta hiveTableMeta = this.hiveClient.getHiveTableMeta(tmpDatabase, tmpView);
            ColumnDesc[] columnDescArray = this.extractColumnFromMeta(hiveTableMeta);
            return columnDescArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot evaluate metadata of query: " + query, e);
        }
        finally {
            try {
                logger.debug("Cleaning up.");
                this.hiveClient.executeHQL(dropViewSql);
            }
            catch (Exception e) {
                logger.warn("Cannot drop temp view of query: {}", (Object)query, (Object)e);
            }
        }
    }

    @Override
    public void validateSQL(String query) throws Exception {
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.addStatement(query);
        Pair<Integer, String> response = KylinConfig.getInstanceFromEnv().getCliCommandExecutor().execute(hiveCmdBuilder.toString());
        if (response.getFirst() != 0) {
            throw new IllegalArgumentException(response.getSecond());
        }
    }

    private ColumnDesc[] extractColumnFromMeta(HiveTableMeta hiveTableMeta) {
        int columnNumber = hiveTableMeta.allColumns.size();
        ArrayList<ColumnDesc> columns = new ArrayList<ColumnDesc>(columnNumber);
        for (int i = 0; i < columnNumber; ++i) {
            HiveTableMeta.HiveTableColumnMeta field = hiveTableMeta.allColumns.get(i);
            if (DataType.isKylinSupported(field.dataType)) {
                ColumnDesc cdesc = new ColumnDesc();
                cdesc.setName(field.name.toUpperCase(Locale.ROOT));
                if ("float".equalsIgnoreCase(field.dataType)) {
                    cdesc.setDatatype("double");
                } else {
                    cdesc.setDatatype(field.dataType);
                }
                cdesc.setId(String.valueOf(i + 1));
                cdesc.setComment(field.comment);
                columns.add(cdesc);
                continue;
            }
            logger.warn("Unsupported data type {}, excluding the field '{}'.", (Object)field.dataType, (Object)field.name);
        }
        return columns.toArray(new ColumnDesc[0]);
    }
}

