/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.NotImplementedException;
import org.apache.kylin.shaded.com.google.common.base.Throwables;

class ExpectedSizeIterator
implements Iterator<byte[]> {
    private BlockingQueue<byte[]> queue;
    private int expectedSize;
    private int current = 0;
    private long coprocessorTimeout;
    private long deadline;
    private volatile Throwable coprocException;

    public ExpectedSizeIterator(int expectedSize, long coprocessorTimeout) {
        this.expectedSize = expectedSize;
        this.queue = new ArrayBlockingQueue<byte[]>(expectedSize);
        this.coprocessorTimeout = coprocessorTimeout;
        this.deadline = System.currentTimeMillis() + coprocessorTimeout * 10L;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.expectedSize;
    }

    @Override
    public byte[] next() {
        if (this.current >= this.expectedSize) {
            throw new NoSuchElementException("Won't have more data");
        }
        try {
            ++this.current;
            byte[] ret = null;
            while (ret == null && this.coprocException == null && this.deadline > System.currentTimeMillis()) {
                ret = this.queue.poll(1000L, TimeUnit.MILLISECONDS);
            }
            if (this.coprocException != null) {
                throw Throwables.propagate(this.coprocException);
            }
            if (ret == null) {
                throw new RuntimeException("Timeout visiting cube! Check why coprocessor exception is not sent back? In coprocessor Self-termination is checked every 100 scanned rows, the configured timeout(" + this.coprocessorTimeout + ") cannot support this many scans?");
            }
            return ret;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Error when waiting queue", e);
        }
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }

    public void append(byte[] data) {
        try {
            this.queue.put(data);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("error when waiting queue", e);
        }
    }

    public void notifyCoprocException(Throwable ex) {
        this.coprocException = ex;
    }
}

