/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.SerializableConfiguration;
import org.apache.kylin.engine.spark.KylinSparkJobListener;
import org.apache.kylin.engine.spark.SparkUtil;
import org.apache.kylin.measure.MeasureCodec;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.storage.hbase.steps.KeyValueCreator;
import org.apache.kylin.storage.hbase.steps.RowKeyWritable;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkCubeHFile
extends AbstractApplication
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(SparkCubeHFile.class);
    public static final Option OPTION_CUBE_NAME;
    public static final Option OPTION_SEGMENT_ID;
    public static final Option OPTION_META_URL;
    public static final Option OPTION_OUTPUT_PATH;
    public static final Option OPTION_INPUT_PATH;
    public static final Option OPTION_PARTITION_FILE_PATH;
    public static final Option OPTION_COUNTER_PATH;
    private Options options = new Options();

    public SparkCubeHFile() {
        this.options.addOption(OPTION_INPUT_PATH);
        this.options.addOption(OPTION_CUBE_NAME);
        this.options.addOption(OPTION_SEGMENT_ID);
        this.options.addOption(OPTION_META_URL);
        this.options.addOption(OPTION_OUTPUT_PATH);
        this.options.addOption(OPTION_PARTITION_FILE_PATH);
        this.options.addOption(AbstractHadoopJob.OPTION_HBASE_CONF_PATH);
        this.options.addOption(OPTION_COUNTER_PATH);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String metaUrl = optionsHelper.getOptionValue(OPTION_META_URL);
        String inputPath = optionsHelper.getOptionValue(OPTION_INPUT_PATH);
        String cubeName = optionsHelper.getOptionValue(OPTION_CUBE_NAME);
        String segmentId = optionsHelper.getOptionValue(OPTION_SEGMENT_ID);
        String outputPath = optionsHelper.getOptionValue(OPTION_OUTPUT_PATH);
        Path partitionFilePath = new Path(optionsHelper.getOptionValue(OPTION_PARTITION_FILE_PATH));
        String hbaseConfFile = optionsHelper.getOptionValue(AbstractHadoopJob.OPTION_HBASE_CONF_PATH);
        String counterPath = optionsHelper.getOptionValue(OPTION_COUNTER_PATH);
        Class[] kryoClassArray = new Class[]{Class.forName("scala.reflect.ClassTag$$anon$1"), KeyValueCreator.class, KeyValue.class, RowKeyWritable.class};
        SparkConf conf = new SparkConf().setAppName("Converting HFile for:" + cubeName + " segment " + segmentId);
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.set("spark.kryo.registrator", "org.apache.kylin.engine.spark.KylinKryoRegistrator");
        conf.set("spark.kryo.registrationRequired", "true").registerKryoClasses(kryoClassArray);
        KylinSparkJobListener jobListener = new KylinSparkJobListener();
        try (JavaSparkContext sc = new JavaSparkContext(conf);){
            sc.sc().addSparkListener((SparkListenerInterface)jobListener);
            FileSystem fs = partitionFilePath.getFileSystem(sc.hadoopConfiguration());
            if (!fs.exists(partitionFilePath)) {
                throw new IllegalArgumentException("File not exist: " + partitionFilePath.toString());
            }
            HadoopUtil.deletePath(sc.hadoopConfiguration(), new Path(outputPath));
            SerializableConfiguration sConf = new SerializableConfiguration(sc.hadoopConfiguration());
            KylinConfig envConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, metaUrl);
            CubeInstance cubeInstance = CubeManager.getInstance(envConfig).getCube(cubeName);
            final CubeDesc cubeDesc = cubeInstance.getDescriptor();
            CubeSegment cubeSegment = cubeInstance.getSegmentById(segmentId);
            final MeasureCodec inputCodec = new MeasureCodec(cubeDesc.getMeasures());
            final ArrayList<KeyValueCreator> keyValueCreators = Lists.newArrayList();
            for (HBaseColumnFamilyDesc cfDesc : cubeDesc.getHbaseMapping().getColumnFamily()) {
                for (HBaseColumnDesc colDesc : cfDesc.getColumns()) {
                    keyValueCreators.add(new KeyValueCreator(cubeDesc, colDesc));
                }
            }
            final int cfNum = keyValueCreators.size();
            boolean quickPath = keyValueCreators.size() == 1 && ((KeyValueCreator)keyValueCreators.get((int)0)).isFullCopy;
            logger.info("Input path: {}", (Object)inputPath);
            logger.info("Output path: {}", (Object)outputPath);
            ArrayList<RowKeyWritable> keys = new ArrayList<RowKeyWritable>();
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, partitionFilePath, sc.hadoopConfiguration());
            Object object = null;
            try {
                RowKeyWritable key = new RowKeyWritable();
                NullWritable value = NullWritable.get();
                while (reader.next((Writable)key, (Writable)value)) {
                    keys.add(key);
                    logger.info(" ------- split key: {}", (Object)key);
                    key = new RowKeyWritable();
                }
            }
            catch (Throwable key) {
                object = key;
                throw key;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable key) {
                            ((Throwable)object).addSuppressed(key);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            logger.info("There are {} split keys, totally {} hfiles", (Object)keys.size(), (Object)(keys.size() + 1));
            logger.info("Loading HBase configuration from:{}", (Object)hbaseConfFile);
            Path hbaseConfFilePath = new Path(hbaseConfFile);
            FileSystem hbaseClusterFs = hbaseConfFilePath.getFileSystem(sc.hadoopConfiguration());
            try (FSDataInputStream confInput = hbaseClusterFs.open(new Path(hbaseConfFile));){
                Configuration hbaseJobConf = new Configuration();
                hbaseJobConf.addResource((InputStream)confInput);
                hbaseJobConf.set("spark.hadoop.dfs.replication", "3");
                Job job = Job.getInstance((Configuration)hbaseJobConf, (String)cubeSegment.getStorageLocationIdentifier());
                FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
                JavaPairRDD inputRDDs = SparkUtil.parseInputPath(inputPath, hbaseClusterFs, sc, Text.class, Text.class);
                JavaPairRDD hfilerdd = quickPath ? inputRDDs.mapToPair((PairFunction)new PairFunction<Tuple2<Text, Text>, RowKeyWritable, KeyValue>(){

                    public Tuple2<RowKeyWritable, KeyValue> call(Tuple2<Text, Text> textTextTuple2) throws Exception {
                        KeyValue outputValue = ((KeyValueCreator)keyValueCreators.get(0)).create((Text)textTextTuple2._1, ((Text)textTextTuple2._2).getBytes(), 0, ((Text)textTextTuple2._2).getLength());
                        return new Tuple2((Object)new RowKeyWritable(outputValue.createKeyOnly(false).getKey()), (Object)outputValue);
                    }
                }) : inputRDDs.flatMapToPair((PairFlatMapFunction)new PairFlatMapFunction<Tuple2<Text, Text>, RowKeyWritable, KeyValue>(){

                    public Iterator<Tuple2<RowKeyWritable, KeyValue>> call(Tuple2<Text, Text> textTextTuple2) throws Exception {
                        ArrayList<Tuple2> result = Lists.newArrayListWithExpectedSize(cfNum);
                        Object[] inputMeasures = new Object[cubeDesc.getMeasures().size()];
                        inputCodec.decode(ByteBuffer.wrap(((Text)textTextTuple2._2).getBytes(), 0, ((Text)textTextTuple2._2).getLength()), inputMeasures);
                        for (int i = 0; i < cfNum; ++i) {
                            KeyValue outputValue = ((KeyValueCreator)keyValueCreators.get(i)).create((Text)textTextTuple2._1, inputMeasures);
                            result.add(new Tuple2((Object)new RowKeyWritable(outputValue.createKeyOnly(false).getKey()), (Object)outputValue));
                        }
                        return result.iterator();
                    }
                });
                hfilerdd.repartitionAndSortWithinPartitions((Partitioner)new HFilePartitioner(keys), (Comparator)((Object)RowKeyWritable.RowKeyComparator.INSTANCE)).mapToPair((PairFunction)new PairFunction<Tuple2<RowKeyWritable, KeyValue>, ImmutableBytesWritable, KeyValue>(){

                    public Tuple2<ImmutableBytesWritable, KeyValue> call(Tuple2<RowKeyWritable, KeyValue> rowKeyWritableKeyValueTuple2) throws Exception {
                        return new Tuple2((Object)new ImmutableBytesWritable(((KeyValue)rowKeyWritableKeyValueTuple2._2).getKey()), rowKeyWritableKeyValueTuple2._2);
                    }
                }).saveAsNewAPIHadoopDataset(job.getConfiguration());
            }
            logger.info("HDFS: Number of bytes written={}", (Object)jobListener.metrics.getBytesWritten());
            HashMap<String, String> counterMap = Maps.newHashMap();
            counterMap.put("hdfs_bytes_written", String.valueOf(jobListener.metrics.getBytesWritten()));
            HadoopUtil.writeToSequenceFile(sc.hadoopConfiguration(), counterPath, counterMap);
        }
    }

    static {
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Name");
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
        OptionBuilder.withArgName((String)"segment");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Segment Id");
        OPTION_SEGMENT_ID = OptionBuilder.create((String)"segmentId");
        OptionBuilder.withArgName((String)"metaUrl");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HDFS metadata url");
        OPTION_META_URL = OptionBuilder.create((String)"metaUrl");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HFile output path");
        OPTION_OUTPUT_PATH = OptionBuilder.create((String)"output");
        OptionBuilder.withArgName((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cuboid files PATH");
        OPTION_INPUT_PATH = OptionBuilder.create((String)"input");
        OptionBuilder.withArgName((String)"partitions");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Partition file path.");
        OPTION_PARTITION_FILE_PATH = OptionBuilder.create((String)"partitions");
        OptionBuilder.withArgName((String)"counterOutput");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"counter output path");
        OPTION_COUNTER_PATH = OptionBuilder.create((String)"counterOutput");
    }

    static class HFilePartitioner
    extends Partitioner {
        private List<RowKeyWritable> keys;

        public HFilePartitioner(List splitKyes) {
            this.keys = splitKyes;
        }

        public int numPartitions() {
            return this.keys.size() + 1;
        }

        public int getPartition(Object o) {
            int pos = Collections.binarySearch(this.keys, (RowKeyWritable)o) + 1;
            return pos < 0 ? -pos : pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            HFilePartitioner that = (HFilePartitioner)((Object)o);
            return Objects.equals(this.keys, that.keys);
        }

        public int hashCode() {
            return Objects.hash(this.keys);
        }
    }
}

