/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.coordinator;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.stream.coordinator.HBaseStreamMetadataStore;
import org.apache.kylin.stream.coordinator.MockStreamMetadataStore;
import org.apache.kylin.stream.coordinator.StreamMetadataStore;
import org.apache.kylin.stream.coordinator.ZookeeperStreamMetadataStore;

public class StreamMetadataStoreFactory {
    public static final String STORE_TYPE_ZK = "zk";
    public static final String STORE_TYPE_HBASE = "hbase";
    public static final String STORE_TYPE_MOCK = "mock";

    public static StreamMetadataStore getStreamMetaDataStore() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        return StreamMetadataStoreFactory.getStreamMetaDataStore(config.getStreamingMetadataStoreType());
    }

    public static StreamMetadataStore getStreamMetaDataStore(String storeType) {
        switch (storeType) {
            case "zk": {
                return StreamMetadataStoreFactory.getZKStreamMetaDataStore();
            }
            case "hbase": {
                return StreamMetadataStoreFactory.getHBaseStreamMetaDataStore();
            }
            case "mock": {
                return StreamMetadataStoreFactory.getMockStreamMetaDataStore();
            }
        }
        throw new IllegalArgumentException("unSupport streaming metadata store type:" + storeType);
    }

    public static StreamMetadataStore getZKStreamMetaDataStore() {
        ZookeeperStreamMetadataStore store = new ZookeeperStreamMetadataStore();
        return store;
    }

    public static StreamMetadataStore getHBaseStreamMetaDataStore() {
        HBaseStreamMetadataStore store = new HBaseStreamMetadataStore();
        return store;
    }

    public static StreamMetadataStore getMockStreamMetaDataStore() {
        MockStreamMetadataStore store = new MockStreamMetadataStore();
        return store;
    }
}

