/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.coordinator.assign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kylin.shaded.com.google.common.base.Function;
import org.apache.kylin.shaded.com.google.common.collect.FluentIterable;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableSet;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.coordinator.StreamingCubeInfo;
import org.apache.kylin.stream.coordinator.assign.Assigner;
import org.apache.kylin.stream.coordinator.assign.AssignmentUtil;
import org.apache.kylin.stream.core.model.CubeAssignment;
import org.apache.kylin.stream.core.model.ReplicaSet;
import org.apache.kylin.stream.core.source.Partition;

public class CubePartitionRoundRobinAssigner
implements Assigner {
    @Override
    public Map<Integer, Map<String, List<Partition>>> reBalancePlan(List<ReplicaSet> replicaSets, List<StreamingCubeInfo> cubes, List<CubeAssignment> existingAssignments) {
        HashMap<Integer, Map<String, List<Partition>>> newPlan = Maps.newHashMap();
        if (replicaSets == null || cubes == null || cubes.size() == 0 || replicaSets.size() == 0) {
            return newPlan;
        }
        ImmutableSet<Integer> rsIdSet = FluentIterable.from(replicaSets).transform(new Function<ReplicaSet, Integer>(){

            @Override
            public Integer apply(ReplicaSet rs) {
                return rs.getReplicaSetID();
            }
        }).toSet();
        Map<Integer, Map<String, List<Partition>>> existingRSAssignmentsMap = AssignmentUtil.convertCubeAssign2ReplicaSetAssign(existingAssignments);
        Set<CubePartition> cubePartitions = this.expandCubePartitions(cubes);
        int avgCubePartitionsPerNode = cubePartitions.size() / replicaSets.size();
        TreeSet<CubePartition> cubePartitionsNeedReassign = Sets.newTreeSet(cubePartitions);
        for (Map.Entry<Integer, Map<String, List<Partition>>> groupAssignmentEntry : existingRSAssignmentsMap.entrySet()) {
            Integer replicaSetID = groupAssignmentEntry.getKey();
            Map<String, List<Partition>> existNodeAssignment = groupAssignmentEntry.getValue();
            if (!rsIdSet.contains(replicaSetID)) continue;
            List<CubePartition> existCubePartitions = this.expandAndIntersectCubePartitions(existNodeAssignment);
            for (CubePartition existCubePartition : existCubePartitions) {
                int cubePartitionCnt;
                if (!cubePartitions.contains(existCubePartition)) continue;
                HashMap<String, List<Partition>> newGroupAssignment = (HashMap<String, List<Partition>>)newPlan.get(replicaSetID);
                if (newGroupAssignment == null) {
                    newGroupAssignment = Maps.newHashMap();
                    newPlan.put(replicaSetID, newGroupAssignment);
                }
                if ((cubePartitionCnt = this.calCubePartitionCnt(newGroupAssignment.values())) >= avgCubePartitionsPerNode + 1) continue;
                this.addToGroupAssignment(newGroupAssignment, existCubePartition.cubeName, existCubePartition.partition);
                cubePartitionsNeedReassign.remove(existCubePartition);
            }
        }
        int rsIdx = 0;
        int rsSize = replicaSets.size();
        LinkedList<CubePartition> cubePartitionsNeedReassignList = Lists.newLinkedList(cubePartitionsNeedReassign);
        while (!cubePartitionsNeedReassignList.isEmpty()) {
            int cubePartitionCnt;
            CubePartition cubePartition = cubePartitionsNeedReassignList.peek();
            String cubeName = cubePartition.cubeName;
            Integer replicaSetID = replicaSets.get(rsIdx).getReplicaSetID();
            HashMap<String, List<Partition>> newGroupAssignment = (HashMap<String, List<Partition>>)newPlan.get(replicaSetID);
            if (newGroupAssignment == null) {
                newGroupAssignment = Maps.newHashMap();
                newPlan.put(replicaSetID, newGroupAssignment);
            }
            if ((cubePartitionCnt = this.calCubePartitionCnt(newGroupAssignment.values())) < avgCubePartitionsPerNode + 1) {
                this.addToGroupAssignment(newGroupAssignment, cubeName, cubePartition.partition);
                cubePartitionsNeedReassignList.remove();
            }
            rsIdx = (rsIdx + 1) % rsSize;
        }
        return newPlan;
    }

    @Override
    public CubeAssignment assign(StreamingCubeInfo cube, List<ReplicaSet> replicaSets, List<CubeAssignment> existingAssignments) {
        Integer replicaSetID;
        int existingTotalPartitionNum = 0;
        int totalPartitionNum = 0;
        final HashMap<Integer, Integer> replicaSetPartitionNumMap = Maps.newHashMap();
        for (CubeAssignment cubeAssignment : existingAssignments) {
            Set<Integer> replicaSetIDs = cubeAssignment.getReplicaSetIDs();
            for (Integer rsID : replicaSetIDs) {
                int rsPartitionNum = cubeAssignment.getPartitionsByReplicaSetID(rsID).size();
                Integer replicaSetPartitionNum = (Integer)replicaSetPartitionNumMap.get(rsID);
                if (replicaSetPartitionNum == null) {
                    replicaSetPartitionNumMap.put(rsID, rsPartitionNum);
                } else {
                    replicaSetPartitionNumMap.put(rsID, rsPartitionNum + replicaSetPartitionNum);
                }
                existingTotalPartitionNum += rsPartitionNum;
            }
        }
        List<Partition> partitionsOfCube = cube.getStreamingTableSourceInfo().getPartitions();
        int cubePartitionNum = partitionsOfCube.size();
        int replicaSetsNum = replicaSets.size();
        int avgPartitionsPerRS = (totalPartitionNum += existingTotalPartitionNum + cubePartitionNum) / replicaSetsNum;
        Collections.sort(replicaSets, new Comparator<ReplicaSet>(){

            @Override
            public int compare(ReplicaSet o1, ReplicaSet o2) {
                Integer partitionNum1Obj = (Integer)replicaSetPartitionNumMap.get(o1.getReplicaSetID());
                int partitionNum1 = partitionNum1Obj == null ? 0 : partitionNum1Obj;
                Integer partitionNum2Obj = (Integer)replicaSetPartitionNumMap.get(o2.getReplicaSetID());
                int partitionNum2 = partitionNum2Obj == null ? 0 : partitionNum2Obj;
                return partitionNum1 - partitionNum2;
            }
        });
        int nextAssignPartitionIdx = 0;
        HashMap<Integer, List<Partition>> assignments = Maps.newHashMap();
        for (ReplicaSet rs : replicaSets) {
            if (nextAssignPartitionIdx >= cubePartitionNum) break;
            replicaSetID = rs.getReplicaSetID();
            Integer partitionNumObj = (Integer)replicaSetPartitionNumMap.get(replicaSetID);
            int partitionNum = partitionNumObj == null ? 0 : partitionNumObj;
            int availableRoom = avgPartitionsPerRS - partitionNum;
            if (availableRoom <= 0) continue;
            int end = nextAssignPartitionIdx + availableRoom < cubePartitionNum ? nextAssignPartitionIdx + availableRoom : cubePartitionNum;
            assignments.put(replicaSetID, Lists.newArrayList(partitionsOfCube.subList(nextAssignPartitionIdx, end)));
            nextAssignPartitionIdx = end;
        }
        if (nextAssignPartitionIdx < cubePartitionNum) {
            for (ReplicaSet rs : replicaSets) {
                if (nextAssignPartitionIdx >= cubePartitionNum) break;
                replicaSetID = rs.getReplicaSetID();
                Partition part = partitionsOfCube.get(nextAssignPartitionIdx);
                ArrayList<Partition> partitions = (ArrayList<Partition>)assignments.get(replicaSetID);
                if (partitions == null) {
                    partitions = Lists.newArrayList();
                    assignments.put(replicaSetID, partitions);
                }
                partitions.add(part);
                ++nextAssignPartitionIdx;
            }
        }
        CubeAssignment cubeAssignment = new CubeAssignment(cube.getCubeName(), assignments);
        return cubeAssignment;
    }

    private int calCubePartitionCnt(Collection<List<Partition>> allPartitions) {
        int size = 0;
        for (List<Partition> partitions : allPartitions) {
            if (partitions == null) continue;
            size += partitions.size();
        }
        return size;
    }

    private Set<CubePartition> expandCubePartitions(List<StreamingCubeInfo> cubes) {
        HashSet<CubePartition> result = Sets.newHashSet();
        for (StreamingCubeInfo cube : cubes) {
            String cubeName = cube.getCubeName();
            List<Partition> partitionsOfCube = cube.getStreamingTableSourceInfo().getPartitions();
            for (Partition partition : partitionsOfCube) {
                result.add(new CubePartition(cubeName, partition));
            }
        }
        return result;
    }

    protected List<CubePartition> expandAndIntersectCubePartitions(Map<String, List<Partition>> nodeAssignment) {
        ArrayList<CubePartition> result = Lists.newArrayList();
        TreeMap reverseMap = Maps.newTreeMap();
        for (Map.Entry<String, List<Partition>> entry : nodeAssignment.entrySet()) {
            String cubeName = entry.getKey();
            List<Partition> partitions = entry.getValue();
            for (Partition partition : partitions) {
                TreeSet<String> cubes = (TreeSet<String>)reverseMap.get(partition);
                if (cubes == null) {
                    cubes = Sets.newTreeSet();
                    reverseMap.put(partition, cubes);
                }
                cubes.add(cubeName);
            }
        }
        for (Map.Entry<String, List<Partition>> entry : reverseMap.entrySet()) {
            Partition partition = (Partition)((Object)entry.getKey());
            Set cubes = (Set)((Object)entry.getValue());
            for (String cube : cubes) {
                CubePartition cubePartition = new CubePartition(cube, partition);
                result.add(cubePartition);
            }
        }
        return result;
    }

    public void addToGroupAssignment(Map<String, List<Partition>> groupAssignment, String cubeName, Partition partition) {
        List<Partition> partitions = groupAssignment.get(cubeName);
        if (partitions == null) {
            partitions = Lists.newArrayList();
            groupAssignment.put(cubeName, partitions);
        }
        partitions.add(partition);
    }

    protected static class CubePartition
    implements Comparable<CubePartition> {
        public String cubeName;
        public Partition partition;

        public CubePartition(String cubeName, Partition partition) {
            this.cubeName = cubeName;
            this.partition = partition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cubeName == null ? 0 : this.cubeName.hashCode());
            result = 31 * result + (this.partition == null ? 0 : this.partition.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CubePartition other = (CubePartition)obj;
            if (this.cubeName == null ? other.cubeName != null : !this.cubeName.equals(other.cubeName)) {
                return false;
            }
            return !(this.partition == null ? other.partition != null : !this.partition.equals(other.partition));
        }

        @Override
        public int compareTo(CubePartition other) {
            int result = this.cubeName.compareTo(other.cubeName);
            if (result != 0) {
                return result;
            }
            return this.partition.getPartitionId() - other.partition.getPartitionId();
        }

        public String toString() {
            return "CubePartition{cubeName='" + this.cubeName + '\'' + ", partition=" + this.partition + '}';
        }
    }
}

