/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.stream.core.model.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeUtil {
    private static final Logger logger = LoggerFactory.getLogger(NodeUtil.class);

    public static Node getCurrentNode(int defaultPort) {
        Node result;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String configNodeStr = kylinConfig.getStreamingNode();
        if (configNodeStr != null) {
            try {
                result = Node.from(configNodeStr);
            }
            catch (IllegalArgumentException e) {
                result = new Node(NodeUtil.getLocalhostName(), Integer.parseInt(configNodeStr));
            }
        } else {
            result = new Node(NodeUtil.getLocalhostName(), defaultPort);
        }
        Map<String, String> nodeProperties = kylinConfig.getStreamingNodeProperties();
        result.setProperties(nodeProperties);
        return result;
    }

    private static String getLocalhostName() {
        String host;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            host = addr.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            logger.error("Fail to get local ip address", e);
            host = "UNKNOWN";
        }
        return host;
    }
}

