/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.util;

import java.nio.ByteBuffer;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;

public class StreamFilterUtil {
    public static IFilterCodeSystem<ByteArray> getStreamingFilterCodeSystem() {
        return new IFilterCodeSystem<ByteArray>(){

            @Override
            public int compare(ByteArray o1, ByteArray o2) {
                return o1.compareTo(o2);
            }

            @Override
            public boolean isNull(ByteArray code) {
                return DimensionEncoding.isNull(code.array(), code.offset(), code.length());
            }

            @Override
            public void serialize(ByteArray code, ByteBuffer buffer) {
                if (code == null) {
                    BytesUtil.writeByteArray(null, 0, 0, buffer);
                } else {
                    BytesUtil.writeByteArray(code.array(), code.offset(), code.length(), buffer);
                }
            }

            @Override
            public ByteArray deserialize(ByteBuffer buffer) {
                return new ByteArray(BytesUtil.readByteArray(buffer));
            }
        };
    }
}

