/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.metrics.MetricCollector;
import net.spy.memcached.metrics.MetricType;
import net.spy.memcached.metrics.NoopMetricCollector;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.kylin.cache.memcached.MemcachedMetrics;
import org.apache.kylin.common.KylinConfig;

public class MemcachedConnectionFactory
extends SpyObject
implements ConnectionFactory {
    private ConnectionFactory underlying;
    private Map<String, String> metricsConfig = KylinConfig.getInstanceFromEnv().getKylinMetricsConf();

    public MemcachedConnectionFactory(ConnectionFactory underlying) {
        this.underlying = underlying;
    }

    public MetricType enableMetrics() {
        String metricType = this.metricsConfig.get("memcached.metricstype");
        return metricType == null ? DefaultConnectionFactory.DEFAULT_METRIC_TYPE : MetricType.valueOf((String)metricType.toUpperCase(Locale.ROOT));
    }

    public MetricCollector getMetricCollector() {
        String enableMetrics = this.metricsConfig.get("memcached.enabled");
        if (this.enableMetrics().equals((Object)MetricType.OFF) || enableMetrics == null || "false".equalsIgnoreCase(enableMetrics)) {
            this.getLogger().debug((Object)"Memcached metrics collection disabled.");
            return new NoopMetricCollector();
        }
        this.getLogger().info((Object)("Memcached metrics collection enabled (Profile " + this.enableMetrics() + ")."));
        return new MemcachedMetrics();
    }

    public MemcachedConnection createConnection(List<InetSocketAddress> addrs) throws IOException {
        return this.underlying.createConnection(addrs);
    }

    public MemcachedNode createMemcachedNode(SocketAddress sa, SocketChannel c, int bufSize) {
        return this.underlying.createMemcachedNode(sa, c, bufSize);
    }

    public BlockingQueue<Operation> createOperationQueue() {
        return this.underlying.createOperationQueue();
    }

    public BlockingQueue<Operation> createReadOperationQueue() {
        return this.underlying.createReadOperationQueue();
    }

    public BlockingQueue<Operation> createWriteOperationQueue() {
        return this.underlying.createWriteOperationQueue();
    }

    public long getOpQueueMaxBlockTime() {
        return this.underlying.getOpQueueMaxBlockTime();
    }

    public ExecutorService getListenerExecutorService() {
        return this.underlying.getListenerExecutorService();
    }

    public boolean isDefaultExecutorService() {
        return this.underlying.isDefaultExecutorService();
    }

    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        return this.underlying.createLocator(nodes);
    }

    public OperationFactory getOperationFactory() {
        return this.underlying.getOperationFactory();
    }

    public long getOperationTimeout() {
        return this.underlying.getOperationTimeout();
    }

    public boolean isDaemon() {
        return this.underlying.isDaemon();
    }

    public boolean useNagleAlgorithm() {
        return this.underlying.useNagleAlgorithm();
    }

    public Collection<ConnectionObserver> getInitialObservers() {
        return this.underlying.getInitialObservers();
    }

    public FailureMode getFailureMode() {
        return this.underlying.getFailureMode();
    }

    public Transcoder<Object> getDefaultTranscoder() {
        return this.underlying.getDefaultTranscoder();
    }

    public boolean shouldOptimize() {
        return this.underlying.shouldOptimize();
    }

    public int getReadBufSize() {
        return this.underlying.getReadBufSize();
    }

    public HashAlgorithm getHashAlg() {
        return this.underlying.getHashAlg();
    }

    public long getMaxReconnectDelay() {
        return this.underlying.getMaxReconnectDelay();
    }

    public AuthDescriptor getAuthDescriptor() {
        return this.underlying.getAuthDescriptor();
    }

    public int getTimeoutExceptionThreshold() {
        return this.underlying.getTimeoutExceptionThreshold();
    }

    public long getAuthWaitTime() {
        return this.underlying.getAuthWaitTime();
    }
}

