/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailTemplateProvider {
    private static final Logger logger = LoggerFactory.getLogger(MailTemplateProvider.class);
    private static MailTemplateProvider DEFAULT_INSTANCE = new MailTemplateProvider();
    private final Configuration configuration = new Configuration(Configuration.getVersion());

    public static MailTemplateProvider getInstance() {
        return DEFAULT_INSTANCE;
    }

    private MailTemplateProvider() {
        this.configuration.setClassForTemplateLoading(MailTemplateProvider.class, "/mail_templates");
        this.configuration.setDefaultEncoding("UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String buildMailContent(String tplKey, Map<String, Object> data) {
        try {
            Template template = this.getTemplate(tplKey);
            if (template == null) {
                return "Cannot find email template for " + tplKey;
            }
            try (StringWriter out = new StringWriter();){
                template.process(data, (Writer)out);
                String string = ((Object)out).toString();
                return string;
            }
        }
        catch (Throwable e) {
            return e.getLocalizedMessage();
        }
    }

    private Template getTemplate(String tplKey) throws Throwable {
        if (StringUtils.isEmpty(tplKey)) {
            return null;
        }
        return this.configuration.getTemplate(tplKey + ".ftl");
    }
}

