/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryBudgetController {
    private static final boolean debug = false;
    public static final MemoryBudgetController ZERO_BUDGET = new MemoryBudgetController(0);
    public static final int ONE_MB = 0x100000;
    public static final long ONE_GB = 0x40000000L;
    private static final Logger logger = LoggerFactory.getLogger(MemoryBudgetController.class);
    private final int totalBudgetMB;
    private final ConcurrentMap<MemoryConsumer, ConsumerEntry> booking = new ConcurrentHashMap<MemoryConsumer, ConsumerEntry>();
    private int totalReservedMB;
    private final ReentrantLock lock = new ReentrantLock();

    public MemoryBudgetController(int totalBudgetMB) {
        Preconditions.checkArgument(totalBudgetMB >= 0);
        Preconditions.checkState(totalBudgetMB <= MemoryBudgetController.getSystemAvailMB());
        this.totalBudgetMB = totalBudgetMB;
        this.totalReservedMB = 0;
    }

    public int getTotalBudgetMB() {
        return this.totalBudgetMB;
    }

    public int getTotalReservedMB() {
        this.lock.lock();
        try {
            int n = this.totalReservedMB;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getRemainingBudgetMB() {
        this.lock.lock();
        try {
            int n = this.totalBudgetMB - this.totalReservedMB;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserveInsist(MemoryConsumer consumer, int requestMB) {
        if (requestMB > this.totalBudgetMB) {
            throw new NotEnoughBudgetException();
        }
        long waitStart = 0L;
        while (true) {
            try {
                this.reserve(consumer, requestMB);
                return;
            }
            catch (NotEnoughBudgetException notEnoughBudgetException) {
                if (waitStart == 0L) {
                    waitStart = System.currentTimeMillis();
                }
                ReentrantLock reentrantLock = this.lock;
                synchronized (reentrantLock) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new NotEnoughBudgetException(e);
                    }
                }
            }
        }
    }

    public void reserve(MemoryConsumer consumer, int requestMB) {
        if (this.totalBudgetMB == 0 && requestMB > 0) {
            throw new NotEnoughBudgetException();
        }
        boolean ok = false;
        while (!ok) {
            int gap = this.calculateGap(consumer, requestMB);
            if (gap > 0) {
                this.tryFreeUp(gap);
            }
            ok = this.updateBooking(consumer, requestMB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int calculateGap(MemoryConsumer consumer, int requestMB) {
        this.lock.lock();
        try {
            ConsumerEntry entry = (ConsumerEntry)this.booking.get(consumer);
            int curMB = entry == null ? 0 : entry.reservedMB;
            int delta = requestMB - curMB;
            int n = delta - (this.totalBudgetMB - this.totalReservedMB);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryFreeUp(int gap) {
        for (ConsumerEntry entry : this.booking.values()) {
            int mb = entry.consumer.freeUp(gap);
            if (mb <= 0) continue;
            this.lock.lock();
            try {
                this.updateBookingWithDelta(entry.consumer, -mb);
            }
            finally {
                this.lock.unlock();
            }
            if ((gap -= mb) > 0) continue;
            break;
        }
        if (gap > 0) {
            throw new NotEnoughBudgetException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateBooking(MemoryConsumer consumer, int requestMB) {
        this.lock.lock();
        try {
            ConsumerEntry entry = (ConsumerEntry)this.booking.get(consumer);
            if (entry == null) {
                if (requestMB == 0) {
                    boolean bl = true;
                    return bl;
                }
                entry = new ConsumerEntry(consumer);
                this.booking.put(consumer, entry);
            }
            int delta = requestMB - entry.reservedMB;
            boolean bl = this.updateBookingWithDelta(consumer, delta);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateBookingWithDelta(MemoryConsumer consumer, int delta) {
        int gap;
        if (delta == 0) {
            return true;
        }
        ConsumerEntry entry = (ConsumerEntry)this.booking.get(consumer);
        if (entry == null) {
            if (delta <= 0) {
                return true;
            }
            entry = new ConsumerEntry(consumer);
            this.booking.put(consumer, entry);
        }
        if (delta > 0 && (gap = delta - (this.totalBudgetMB - this.totalReservedMB)) > 0) {
            return false;
        }
        this.totalReservedMB += delta;
        entry.reservedMB += delta;
        if (entry.reservedMB == 0) {
            this.booking.remove(entry.consumer);
        }
        if (delta < 0) {
            ReentrantLock reentrantLock = this.lock;
            synchronized (reentrantLock) {
                this.lock.notifyAll();
            }
        }
        return true;
    }

    public static int gcAndGetSystemAvailMB() {
        boolean tolerance = true;
        try {
            int lastMB = -1;
            while (true) {
                Runtime.getRuntime().gc();
                Thread.sleep(1000L);
                int thisMB = MemoryBudgetController.getSystemAvailMB();
                if (lastMB < 0) {
                    lastMB = thisMB;
                    continue;
                }
                if (lastMB - thisMB < 1) {
                    return thisMB;
                }
                lastMB = thisMB;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("", e);
            return MemoryBudgetController.getSystemAvailMB();
        }
    }

    public static long getSystemAvailBytes() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        long usedMemory = totalMemory - freeMemory;
        long availableMemory = maxMemory - usedMemory;
        return availableMemory;
    }

    public static int getSystemAvailMB() {
        return (int)(MemoryBudgetController.getSystemAvailBytes() / 0x100000L);
    }

    public static class MemoryWaterLevel {
        int lowAvail = Integer.MAX_VALUE;
        int highAvail = Integer.MIN_VALUE;

        public void markHigh() {
            int mb = MemoryBudgetController.getSystemAvailMB();
            if (mb < this.lowAvail) {
                this.lowAvail = mb;
                logger.warn("Lower system avail " + this.lowAvail + " MB in markHigh()");
            }
        }

        public void markLow() {
            int mb = MemoryBudgetController.gcAndGetSystemAvailMB();
            if (mb > this.highAvail) {
                this.highAvail = mb;
                logger.warn("Higher system avail " + this.highAvail + " MB in markLow()");
            }
        }

        public int getEstimateMB() {
            return this.highAvail - this.lowAvail;
        }
    }

    private static class ConsumerEntry {
        final MemoryConsumer consumer;
        int reservedMB;

        ConsumerEntry(MemoryConsumer consumer) {
            this.consumer = consumer;
        }
    }

    public static class NotEnoughBudgetException
    extends IllegalStateException {
        public NotEnoughBudgetException() {
        }

        public NotEnoughBudgetException(Throwable cause) {
            super(cause);
        }
    }

    public static interface MemoryConsumer {
        public int freeUp(int var1);
    }
}

