/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dimension.DateDimEnc;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;

public class DateStrDictionary
extends Dictionary<String> {
    private String pattern;
    private int baseId;
    private int maxId;

    public DateStrDictionary() {
        this.init("yyyy-MM-dd", 0);
    }

    public DateStrDictionary(String datePattern, int baseId) {
        this.init(datePattern, baseId);
    }

    private void init(String datePattern, int baseId) {
        this.pattern = datePattern;
        this.baseId = baseId;
        this.maxId = baseId + 3652426;
    }

    @Override
    public int getMinId() {
        return this.baseId;
    }

    @Override
    public int getMaxId() {
        return this.maxId;
    }

    @Override
    public int getSizeOfId() {
        return 3;
    }

    @Override
    public int getSizeOfValue() {
        return this.pattern.length();
    }

    @Override
    protected final int getIdFromValueImpl(String value, int roundFlag) {
        Date date = DateFormat.stringToDate(value, this.pattern);
        int id = this.calcIdFromSeqNo((int)DateDimEnc.getNumOfDaysSince0000FromMillis(date.getTime()));
        if (id < this.baseId || id > this.maxId) {
            throw new IllegalArgumentException("'" + value + "' encodes to '" + id + "' which is out of range [" + this.baseId + "," + this.maxId + "]");
        }
        return id;
    }

    @Override
    protected final String getValueFromIdImpl(int id) {
        if (id < this.baseId || id > this.maxId) {
            throw new IllegalArgumentException("ID '" + id + "' is out of range [" + this.baseId + "," + this.maxId + "]");
        }
        long millis = DateDimEnc.getMillisFromNumOfDaysSince0000(this.calcSeqNoFromId(id));
        return DateFormat.dateToString(new Date(millis), this.pattern);
    }

    private int calcIdFromSeqNo(int seq) {
        return seq < 0 ? seq : this.baseId + seq;
    }

    private int calcSeqNoFromId(int id) {
        return id - this.baseId;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.pattern);
        out.writeInt(this.baseId);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String pattern = in.readUTF();
        int baseId = in.readInt();
        this.init(pattern, baseId);
    }

    public int hashCode() {
        return 31 * this.baseId + this.pattern.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateStrDictionary)) {
            return false;
        }
        DateStrDictionary that = (DateStrDictionary)o;
        return StringUtils.equals(this.pattern, that.pattern) && this.baseId == that.baseId;
    }

    @Override
    public boolean contains(Dictionary<?> other) {
        return this.equals(other);
    }

    @Override
    public void dump(PrintStream out) {
        out.println(this.toString());
    }

    public String toString() {
        return "DateStrDictionary [pattern=" + this.pattern + ", baseId=" + this.baseId + "]";
    }
}

