/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.flink;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.hadoopcompatibility.HadoopInputs;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.flink.IFlinkInput;
import org.apache.kylin.engine.flink.IFlinkOutput;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.source.SourceManager;
import org.apache.kylin.storage.StorageFactory;

public class FlinkUtil {
    public static IFlinkInput.IFlinkBatchCubingInputSide getBatchCubingInputSide(CubeSegment seg) {
        IJoinedFlatTableDesc flatDesc = EngineFactory.getJoinedFlatTableDesc(seg);
        return SourceManager.createEngineAdapter(seg, IFlinkInput.class).getBatchCubingInputSide(flatDesc);
    }

    public static IFlinkOutput.IFlinkBatchCubingOutputSide getBatchCubingOutputSide(CubeSegment seg) {
        return StorageFactory.createEngineAdapter(seg, IFlinkOutput.class).getBatchCubingOutputSide(seg);
    }

    public static IFlinkOutput.IFlinkBatchMergeOutputSide getBatchMergeOutputSide2(CubeSegment seg) {
        return StorageFactory.createEngineAdapter(seg, IFlinkOutput.class).getBatchMergeOutputSide(seg);
    }

    public static IFlinkInput.IFlinkBatchMergeInputSide getBatchMergeInputSide(CubeSegment seg) {
        return SourceManager.createEngineAdapter(seg, IFlinkInput.class).getBatchMergeInputSide(seg);
    }

    public static IMROutput2.IMRBatchOptimizeOutputSide2 getBatchOptimizeOutputSide2(CubeSegment seg) {
        return StorageFactory.createEngineAdapter(seg, IMROutput2.class).getBatchOptimizeOutputSide(seg);
    }

    public static DataSet parseInputPath(String inputPath, FileSystem fs, ExecutionEnvironment env, Class keyClass, Class valueClass) throws IOException {
        ArrayList<String> inputFolders = Lists.newArrayList();
        Path inputHDFSPath = new Path(inputPath);
        FileStatus[] fileStatuses = fs.listStatus(inputHDFSPath);
        boolean hasDir = false;
        for (FileStatus stat : fileStatuses) {
            if (!stat.isDirectory() || stat.getPath().getName().startsWith("_")) continue;
            hasDir = true;
            inputFolders.add(stat.getPath().toString());
        }
        if (!hasDir) {
            return env.createInput((org.apache.flink.api.common.io.InputFormat)HadoopInputs.readSequenceFile((Class)keyClass, (Class)valueClass, (String)inputHDFSPath.toString()));
        }
        Job job = Job.getInstance();
        FileInputFormat.setInputPaths((Job)job, (String)StringUtil.join(inputFolders, ","));
        return env.createInput((org.apache.flink.api.common.io.InputFormat)HadoopInputs.createHadoopInput((InputFormat)new SequenceFileInputFormat(), (Class)keyClass, (Class)valueClass, (Job)job));
    }

    public static void setHadoopConfForCuboid(Job job, CubeSegment segment, String metaUrl) throws Exception {
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
    }

    public static void modifyFlinkHadoopConfiguration(Job job) throws Exception {
        job.getConfiguration().set("dfs.replication", KylinConfig.getInstanceFromEnv().getCuboidDfsReplication());
        job.getConfiguration().set("mapreduce.output.fileoutputformat.compress", "true");
        job.getConfiguration().set("mapreduce.output.fileoutputformat.compress.type", "BLOCK");
        job.getConfiguration().set("mapreduce.output.fileoutputformat.compress.codec", "org.apache.hadoop.io.compress.DefaultCodec");
    }

    public static DataSet<String[]> readHiveRecords(boolean isSequenceFile, ExecutionEnvironment env, String inputPath, String hiveTable, Job job) throws IOException {
        if (!isSequenceFile) {
            throw new UnsupportedOperationException("Currently, Flink does not support read hive table directly.");
        }
        MapOperator recordDataSet = env.createInput((org.apache.flink.api.common.io.InputFormat)HadoopInputs.readHadoopFile((FileInputFormat)new SequenceFileInputFormat(), BytesWritable.class, Text.class, (String)inputPath, (Job)job), TypeInformation.of((TypeHint)new TypeHint<Tuple2<BytesWritable, Text>>(){})).map((MapFunction)new MapFunction<Tuple2<BytesWritable, Text>, String[]>(){

            public String[] map(Tuple2<BytesWritable, Text> tuple2) throws Exception {
                String s = Bytes.toString(((Text)tuple2.f1).getBytes(), 0, ((Text)tuple2.f1).getLength());
                return s.split("\u0001");
            }
        });
        return recordDataSet;
    }
}

